import { Injectable } from '@nestjs/common';
import { InjectModel } from '@nestjs/mongoose';
import { Model } from 'mongoose';
import { SettingsDto } from './settings.dto';
import { Setting, SettingSchema } from './setting.schema';

@Injectable()
export class SettingsService {
  constructor(
    @InjectModel(Setting.name) private settingsModel: Model<Setting>,
  ) {}

  async createIncrement(settingsDto: SettingsDto): Promise<Setting> {
    const newSetting = new this.settingsModel(settingsDto);
    return newSetting.save();
  }

  async findAll(): Promise<Setting[]> {
    return this.settingsModel.find().exec();
  }

  async delete(id: string): Promise<any> {
    return this.settingsModel.findByIdAndDelete(id).exec();
  }
}
