import { IsEmail, IsNotEmpty, IsString, Matches, MinLength, IsOptional  } from 'class-validator';

export class CreateUserDto {
  @IsNotEmpty()
  @IsString()
  firstname: string;

  @IsNotEmpty()
  @IsString()
  lastname: string;

  @IsNotEmpty()
  @IsEmail()
  email: string;

  @Matches(/^(\+\d{1,3}[- ]?)?\d{10}$/, {
    message: 'Phone number must be valid',
  })
  phone: string;

  @IsNotEmpty()
  @MinLength(8, {
    message: 'Password must be at least 8 characters long',
  })
  password: string;

  @IsString()
  @IsOptional()
  userRole: string = 'user'; // Default value

  @IsString()
  @IsOptional()
  userType: string = 'user'; // Default value
}
