import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document } from 'mongoose';

@Schema()
export class User extends Document {
  @Prop({ required: true })
  firstname: string;

  @Prop({ required: true })
  lastname: string;

  @Prop({ required: true, unique: true })
  email: string;

  @Prop()
  phone: string;

  @Prop({ required: true })
  password: string;

  @Prop({ default: 'user' }) // Default value for userRole
  userRole: string;

  @Prop({ default: 'user' }) // Default value for userType
  userType: string;
}

export const UserSchema = SchemaFactory.createForClass(User);
