import { CategoriesService } from './categories.service';
import { Category } from './schemas/category.schema';
import { CategoryDto } from './dto/category.dto';
export declare class CategoriesController {
    private readonly categoriesService;
    constructor(categoriesService: CategoriesService);
    create(categoryDto: CategoryDto, image: Express.Multer.File): Promise<Category>;
    checkIfExists(name: string): Promise<boolean>;
    findCategoryByName(name: string): Promise<Category>;
    findAll(): Promise<Category[]>;
    findOne(id: string): Promise<Category>;
    update(id: string, categoryDto: CategoryDto, image: Express.Multer.File): Promise<Category>;
    delete(id: string): Promise<any>;
    findAllWithoutLogin(): Promise<Category[]>;
    findAllParentWithoutLogin(): Promise<Category[]>;
    findhierarchy(): Promise<Category[]>;
}
