import { Model } from 'mongoose';
import { Category } from './schemas/category.schema';
export declare class CategoriesService {
    private categoryModel;
    constructor(categoryModel: Model<Category>);
    create(categoryDto: Partial<Category>): Promise<Category>;
    findAll(): Promise<Category[]>;
    findOne(id: string): Promise<Category>;
    update(id: string, categoryDto: Partial<Category>): Promise<Category>;
    findByName(name: string): Promise<Category>;
    delete(id: string): Promise<any>;
    findCategoryByName(name: string): Promise<Category>;
    findAllParent(): Promise<Category[]>;
    findHierarchy(): Promise<Category[]>;
}
