"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CategoriesService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const mongoose_2 = require("mongoose");
const category_schema_1 = require("./schemas/category.schema");
let CategoriesService = class CategoriesService {
    constructor(categoryModel) {
        this.categoryModel = categoryModel;
    }
    async create(categoryDto) {
        try {
            const newCategory = new this.categoryModel(categoryDto);
            return await newCategory.save();
        }
        catch (error) {
            if (error.code === 11000) {
                throw new common_1.ConflictException('Category name already exists.');
            }
            throw new common_1.InternalServerErrorException('Something went wrong');
        }
    }
    async findAll() {
        return this.categoryModel.find().exec();
    }
    async findOne(id) {
        return this.categoryModel.findById(id).exec();
    }
    async update(id, categoryDto) {
        try {
            const category = await this.categoryModel.findById(id);
            if (!category) {
                throw new Error('Product not found');
            }
            if (categoryDto.image) {
                category.image = categoryDto.image;
            }
            Object.keys(categoryDto).forEach((key) => {
                if (key !== 'image') {
                    category[key] = categoryDto[key];
                }
            });
            await category.save();
            return category;
        }
        catch (error) {
            if (error.code === 11000) {
                throw new common_1.ConflictException('Category name already exists.');
            }
            throw new common_1.InternalServerErrorException('Something went wrong');
        }
    }
    async findByName(name) {
        const category = await this.categoryModel.findOne({ name }).exec();
        if (!category) {
            throw new common_1.NotFoundException(`Category with name "${name}" not found`);
        }
        return category;
    }
    async delete(id) {
        return this.categoryModel.findByIdAndDelete(id).exec();
    }
    async findCategoryByName(name) {
        return this.categoryModel.findOne({ name }).exec();
    }
    async findAllParent() {
        return this.categoryModel.find({ parent: 0 }).exec();
    }
    async findHierarchy() {
        const categories = await this.categoryModel.aggregate([
            {
                $graphLookup: {
                    from: 'categories',
                    startWith: '$_id',
                    connectFromField: '_id',
                    connectToField: 'parent',
                    as: 'children',
                },
            },
            {
                $match: { parent: 0 },
            },
            {
                $sort: { name: 1 },
            },
        ]);
        return categories;
    }
};
exports.CategoriesService = CategoriesService;
exports.CategoriesService = CategoriesService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(category_schema_1.Category.name)),
    __metadata("design:paramtypes", [mongoose_2.Model])
], CategoriesService);
//# sourceMappingURL=categories.service.js.map