"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const app_module_1 = require("./app.module");
const common_1 = require("@nestjs/common");
const cors = require("cors");
const bodyParser = require("body-parser");
const fs = require("fs");
const path = require("path");
async function bootstrap() {
    const httpsOptions = {
        key: fs.readFileSync(path.join(__dirname, '../src/certificates/private.key')),
        cert: fs.readFileSync(path.join(__dirname, '../src/certificates/certificate.crt')),
        ca: fs.readFileSync(path.join(__dirname, '../src/certificates/ca_bundle.crt')),
    };
    const app = await core_1.NestFactory.create(app_module_1.AppModule, {
        httpsOptions,
    });
    app.use(bodyParser.urlencoded({ extended: true }));
    app.use(cors());
    app.useGlobalPipes(new common_1.ValidationPipe({ transform: true }));
    await app.listen(process.env.PORT ?? 3035);
}
bootstrap();
//# sourceMappingURL=main.js.map