import { Model } from 'mongoose';
import { Product } from '../products/schemas/product.schema';
import { Cart } from '../products/schemas/cart.schema';
import { Order } from './schemas/order.schema';
import { User } from '../users/schemas/user.schema';
import { EmailService } from '../email/email.service';
export declare class PaymentService {
    private cartModel;
    private orderModel;
    private userModel;
    private productModel;
    private readonly emailService;
    constructor(cartModel: Model<Cart>, orderModel: Model<Order>, userModel: Model<User>, productModel: Model<Product>, emailService: EmailService);
    private keyId;
    private keySecret;
    private razorpayBaseUrl;
    createOrder(body: any, user: any): Promise<any>;
    verifyPaymentSignature(orderId: string, paymentId: string, signature: string, user: any): Promise<boolean>;
    sendEmail(to: any, name: any, plain: any, content: any, subject: any): Promise<any>;
    getOrder(body: any, user: any): Promise<any>;
    getMyOrders(body: any, user: any): Promise<any>;
    getAllOrders(body: any, user: any): Promise<any>;
}
