"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaymentService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const mongoose_2 = require("mongoose");
const crypto = require("crypto");
const axios_1 = require("axios");
const dotenv = require("dotenv");
const product_schema_1 = require("../products/schemas/product.schema");
const cart_schema_1 = require("../products/schemas/cart.schema");
const order_schema_1 = require("./schemas/order.schema");
const user_schema_1 = require("../users/schemas/user.schema");
const email_service_1 = require("../email/email.service");
dotenv.config();
let PaymentService = class PaymentService {
    constructor(cartModel, orderModel, userModel, productModel, emailService) {
        this.cartModel = cartModel;
        this.orderModel = orderModel;
        this.userModel = userModel;
        this.productModel = productModel;
        this.emailService = emailService;
        this.keyId = process.env.RAZORPAY_KEY_ID;
        this.keySecret = process.env.RAZORPAY_SECRET;
        this.razorpayBaseUrl = 'https://api.razorpay.com/v1';
    }
    async createOrder(body, user) {
        try {
            const auth = Buffer.from(`${this.keyId}:${this.keySecret}`).toString('base64');
            const receipt = `receipt_${Date.now()}`;
            const response = await axios_1.default.post(`${this.razorpayBaseUrl}/orders`, {
                amount: body.amount * 100,
                currency: 'INR',
                receipt: receipt,
            }, {
                headers: {
                    Authorization: `Basic ${auth}`,
                    'Content-Type': 'application/json',
                },
            });
            console.log(response.data);
            var cart = await this.cartModel.findOne({ user: new mongoose_2.Types.ObjectId(user) }).exec();
            const order = new this.orderModel({
                amount: body.amount,
                receipt: receipt,
                orderId: response.data.id,
                address1: body.address1,
                address2: body.address2,
                address3: body.address3,
                country: body.country,
                city: body.city,
                state: body.state,
                pincode: body.pincode,
                items: cart.items,
                user: user
            });
            return { orderId: response.data.id, amount: body.amount, keyId: this.keyId, order: await order.save() };
            return response.data;
        }
        catch (error) {
            throw new common_1.HttpException(error.response?.data || 'Error creating Razorpay order', common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async verifyPaymentSignature(orderId, paymentId, signature, user) {
        const generatedSignature = crypto
            .createHmac('sha256', this.keySecret)
            .update(`${orderId}|${paymentId}`)
            .digest('hex');
        if (generatedSignature === signature) {
            await this.orderModel.findOneAndUpdate({ orderId: orderId }, {
                $set: { paymentId: paymentId, signature: signature, status: 1 }
            }, { new: true, upsert: true });
            var products = await this.orderModel.findOne({ orderId: orderId });
            await Promise.all(products.items.map(async (item) => {
                const product = await this.productModel.findById(item.productId);
                if (!product)
                    return;
                let statusValue = -1;
                console.log(product.auctionStatus);
                if (product.auctionStatus != '1') {
                    await this.productModel.updateOne({ _id: product._id }, { $set: { auctionStatus: '1', finaluser: user } });
                    statusValue = 1;
                }
                await this.orderModel.updateOne({ orderId: orderId, "items.productId": item.productId }, { $set: { "items.$.status": statusValue } });
                const userdata = await this.userModel.findById(user).exec();
                if (statusValue == 1) {
                    var plain = "Dear " + userdata.firstname + ' ' + userdata.lastname + ", Thank you for your purchase at Travancore Heritage Auction! We are pleased to inform you that your payment has been successfully received, and your order has been confirmed. Order ID: " + orderId + ", Item Name: " + product.name + ",Amount Paid: " + products.amount + ",Payment Method: RazorPay. Our team will process your order shortly. You will receive further updates regarding dispatch and delivery. If you have any questions, feel free to reach out to us at info@travancoreheritageauction.com or call us at +91 88480 44033. Thank you for choosing Travancore Heritage Auction! Best regards, Travancore Heritage Auction Team, www.travancoreheritageauction.com";
                    var content = "<p>Dear " + userdata.firstname + ' ' + userdata.lastname + ",</p><br> <p>Thank you for your purchase at Travancore Heritage Auction! We are pleased to inform you that your payment has been successfully received, and your order has been confirmed.</p><br><br> <p>Order ID: " + orderId + ",</p><br> <p>Item Name: " + product.name + ",</p><br> <p>Amount Paid: " + products.amount + "</p> <p>Payment Method: RazorPay</p><br> <p>. Our team will process your order shortly. You will receive further updates regarding dispatch and delivery. If you have any questions, feel free to reach out to us at info@travancoreheritageauction.com or call us at +91 88480 44033. </p> <br><p>Thank you for choosing Travancore Heritage Auction!.</p> <p>Best regards,<br> Travancore Heritage Auction Team,<br> www.travancoreheritageauction.com</p>";
                    var subject = "Order Confirmation – Thank You for Your Purchase!";
                    this.sendEmail("info@travancoreheritageauction.com", userdata.firstname + ' ' + userdata.lastname, plain, content, subject);
                    this.sendEmail(userdata.email, userdata.firstname + ' ' + userdata.lastname, plain, content, subject);
                }
                if (statusValue != 1) {
                    var plain = "Dear " + userdata.firstname + ' ' + userdata.lastname + ", Thank you for your recent purchase at Travancore Heritage Auction. Unfortunately, due to high demand, the item  " + product.name + " was sold to another buyer during the transaction processing time. We sincerely apologize for this inconvenience. We have initiated a full refund of " + products.amount + " to your original payment method. The refund should reflect in your account within [X] business days, depending on your bank's processing time. Order ID: " + orderId + ", Item Name: " + product.name + ",Amount Refunded: " + products.amount + ",Refund Status: Initiated. Our team will process your order shortly. You will receive further updates regarding dispatch and delivery. If you have any questions, feel free to reach out to us at info@travancoreheritageauction.com or call us at +91 88480 44033. Thank you for choosing Travancore Heritage Auction! Best regards, Travancore Heritage Auction Team, www.travancoreheritageauction.com";
                    var content = "<p>Dear " + userdata.firstname + ' ' + userdata.lastname + ",</p><br> <p>Thank you for your recent purchase at Travancore Heritage Auction. Unfortunately, due to high demand, the item  " + product.name + " was sold to another buyer during the transaction processing time. We sincerely apologize for this inconvenience. We have initiated a full refund of " + products.amount + " to your original payment method. The refund should reflect in your account within [X] business days, depending on your bank's processing time.</p><br><br> <p>Order ID: " + orderId + ",</p><br> <p>Item Name: " + product.name + ",</p><br> <p>Amount Refunded: " + products.amount + "</p> <p>Refund Status: Initiated</p><br> <p>. Our team will process your order shortly. You will receive further updates regarding dispatch and delivery. If you have any questions, feel free to reach out to us at info@travancoreheritageauction.com or call us at +91 88480 44033. </p> <br><p>Thank you for choosing Travancore Heritage Auction!.</p> <p>Best regards,<br> Travancore Heritage Auction Team,<br> www.travancoreheritageauction.com</p>";
                    var subject = "Refund Initiated for Your Purchase";
                    this.sendEmail("info@travancoreheritageauction.com", userdata.firstname + ' ' + userdata.lastname, plain, content, subject);
                    this.sendEmail(userdata.email, userdata.firstname + ' ' + userdata.lastname, plain, content, subject);
                }
            }));
            await this.cartModel.findOneAndUpdate({ user: new mongoose_2.Types.ObjectId(user) }, { items: [] });
            return true;
        }
        else {
            return false;
        }
    }
    async sendEmail(to, name, plain, content, subject) {
        const mailjetAPIKey = 'a827249b18ef476acc5eb882fca8c1dd';
        const mailjetAPISecret = '8fb49d646c35592d0814f9ae7da771c4';
        const mailData = {
            Messages: [
                {
                    From: {
                        Email: "info@travancoreheritageauction.com",
                        Name: "Travancore Heritage Auction"
                    },
                    To: [
                        {
                            Email: to,
                            Name: name
                        }
                    ],
                    Subject: subject,
                    TextPart: plain,
                    HTMLPart: content
                }
            ]
        };
        try {
            const response = await axios_1.default.post('https://api.mailjet.com/v3.1/send', mailData, {
                headers: { 'Content-Type': 'application/json' },
                auth: {
                    username: mailjetAPIKey,
                    password: mailjetAPISecret
                }
            });
            return 1;
        }
        catch (error) {
            return 2;
        }
    }
    ;
    async getOrder(body, user) {
        return await this.orderModel.findOne({ orderId: body.orderId })
            .populate({
            path: 'items.productId',
            model: 'Product'
        })
            .populate('user');
        ;
    }
    async getMyOrders(body, user) {
        return await this.orderModel.find({ user: user })
            .populate({
            path: 'items.productId',
            model: 'Product'
        });
    }
    async getAllOrders(body, user) {
        return await this.orderModel.find()
            .populate({
            path: 'items.productId',
            model: 'Product'
        })
            .populate('user');
    }
};
exports.PaymentService = PaymentService;
exports.PaymentService = PaymentService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(cart_schema_1.Cart.name)),
    __param(1, (0, mongoose_1.InjectModel)(order_schema_1.Order.name)),
    __param(2, (0, mongoose_1.InjectModel)(user_schema_1.User.name)),
    __param(3, (0, mongoose_1.InjectModel)(product_schema_1.Product.name)),
    __metadata("design:paramtypes", [mongoose_2.Model,
        mongoose_2.Model,
        mongoose_2.Model,
        mongoose_2.Model,
        email_service_1.EmailService])
], PaymentService);
//# sourceMappingURL=payment.service.js.map