import { ProductService } from './product.service';
import { Product } from './schemas/product.schema';
import { ProductDto } from './dto/product.dto';
import { PaginationQueryDto } from './dto/pagination-query.dto';
export declare class ProductController {
    private readonly productService;
    constructor(productService: ProductService);
    create(body: any, productDto: ProductDto, files: Express.Multer.File[]): Promise<Product>;
    findAll(): Promise<Product[]>;
    getProducts(paginationQuery: PaginationQueryDto): Promise<{
        data: (import("mongoose").Document<unknown, {}, Product> & Product & Required<{
            _id: unknown;
        }> & {
            __v: number;
        })[];
        total: number;
        page: number;
        limit: number;
        totalPages: number;
    }>;
    getAllProducts(paginationQuery: PaginationQueryDto): Promise<{
        data: (import("mongoose").Document<unknown, {}, Product> & Product & Required<{
            _id: unknown;
        }> & {
            __v: number;
        })[];
        total: number;
        page: number;
        limit: number;
        totalPages: number;
    }>;
    findOne(id: string): Promise<Product>;
    update(id: string, body: any, productDto: ProductDto, files: Express.Multer.File[]): Promise<Product>;
    remove(id: string): Promise<void>;
    getCategoriesWithProductCount(): Promise<any[]>;
    getMainCategoriesWithProductCount(): Promise<any[]>;
    getProductsByCategory(body: any): Promise<any[]>;
    getProductBySKU(body: any): Promise<Product>;
    getProductBySKULanding(body: any): Promise<any>;
    getProductByLots(paginationQuery: PaginationQueryDto): Promise<any>;
    getProductByPastLots(paginationQuery: PaginationQueryDto): Promise<any>;
    getProductByStore(paginationQuery: PaginationQueryDto): Promise<any>;
    postNewBid(body: any, req: any): Promise<any>;
    postNewReserve(body: any, req: any): Promise<any>;
    getBidHistory(body: any, req: any): Promise<any>;
    getSecretHistory(body: any, req: any): Promise<any>;
    getBidReserve(body: any, req: any): Promise<any>;
    addBanner(body: any, req: any): Promise<any>;
    removeBanner(body: any, req: any): Promise<any>;
    homeBanner(body: any, req: any): Promise<any>;
    upcomingAuctions(body: any, req: any): Promise<any>;
    liveAuctions(body: any, req: any): Promise<any>;
    pastAuctions(body: any, req: any): Promise<any>;
    switchLotAuction(body: any): Promise<any>;
    bulkUpdate(body: any): Promise<any>;
    deleteImage(body: any, req: any): Promise<any>;
    getMyBids(body: any, req: any): Promise<any>;
    getMyDashboard(body: any, req: any): Promise<any>;
    getAdjacentProductsBySku(body: any): Promise<{
        previous: any;
        current: any;
        next: any;
    }>;
    getAllBids(body: any, req: any): Promise<any>;
    requestVideo(body: any, req: any): Promise<any>;
    myrequestedVideo(body: any, req: any): Promise<any>;
    allrequestedVideo(body: any, req: any): Promise<any>;
    getCurrentAndNextLot(): Promise<any>;
    gethomeCurrentAndNextLot(): Promise<any>;
    generateResult(body: any, req: any): Promise<any>;
    getActiveLot(): Promise<any>;
    getNextActiveLot(): Promise<any>;
    lastResult(): Promise<any>;
    getCart(body: any, req: any): Promise<import("./schemas/cart.schema").Cart>;
    addToCart(body: any, req: any): Promise<any>;
    isProductInCart(body: any, req: any): Promise<{
        exists: boolean;
    }>;
    removeFromCart(body: any, req: any): Promise<any>;
    clearCart(body: any, req: any): Promise<any>;
    changeManulStatus(body: any, req: any): Promise<any>;
}
