"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductController = void 0;
const common_1 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const multer_1 = require("multer");
const product_service_1 = require("./product.service");
const product_dto_1 = require("./dto/product.dto");
const pagination_query_dto_1 = require("./dto/pagination-query.dto");
const path_1 = require("path");
const jwt_auth_guard_1 = require("../auth/jwt-auth.guard");
const mongoose = require('mongoose');
let ProductController = class ProductController {
    constructor(productService) {
        this.productService = productService;
    }
    async create(body, productDto, files) {
        const transformed = new product_dto_1.ProductDto();
        Object.assign(transformed, body);
        if (files && files.length > 0) {
            transformed.images = files.map((file) => file.filename);
        }
        transformed.category = new mongoose.Types.ObjectId(transformed.category);
        console.log('Transformed DTO:', transformed);
        transformed.auctionStartDate = transformed.auctionStartDate ? new Date(transformed.auctionStartDate) : null;
        transformed.auctionEndDate = transformed.auctionEndDate ? new Date(transformed.auctionEndDate) : null;
        return this.productService.create(transformed);
    }
    async findAll() {
        console.log("here");
        return this.productService.findAll();
    }
    async getProducts(paginationQuery) {
        return this.productService.findAllPages(paginationQuery);
    }
    async getAllProducts(paginationQuery) {
        return this.productService.findAllProductsPages(paginationQuery);
    }
    async findOne(id) {
        return this.productService.findOne(id);
    }
    async update(id, body, productDto, files) {
        const transformed = new product_dto_1.ProductDto();
        Object.assign(transformed, body);
        const newImages = files && files.length > 0 ? files.map((file) => file.filename) : [];
        transformed.category = new mongoose.Types.ObjectId(transformed.category);
        console.log('Transformed DTO:', transformed);
        transformed.auctionStartDate = transformed.auctionStartDate ? new Date(transformed.auctionStartDate) : null;
        transformed.auctionEndDate = transformed.auctionEndDate ? new Date(transformed.auctionEndDate) : null;
        return this.productService.updateWithImages(id, transformed, newImages);
    }
    async remove(id) {
        return this.productService.remove(id);
    }
    async getCategoriesWithProductCount() {
        return this.productService.getCategoriesWithProductCount();
    }
    async getMainCategoriesWithProductCount() {
        return this.productService.getMainCategoriesWithProductCount();
    }
    async getProductsByCategory(body) {
        return this.productService.getProductsByCategory(body.name);
    }
    async getProductBySKU(body) {
        return this.productService.findBySKU(body.sku);
    }
    async getProductBySKULanding(body) {
        return this.productService.getProductBySKULanding(body.sku);
    }
    async getProductByLots(paginationQuery) {
        return this.productService.findByLots(paginationQuery);
    }
    async getProductByPastLots(paginationQuery) {
        return this.productService.findByPastLots(paginationQuery);
    }
    async getProductByStore(paginationQuery) {
        return this.productService.getProductByStore(paginationQuery);
    }
    async postNewBid(body, req) {
        return this.productService.newBid(body, req.user.userId);
    }
    async postNewReserve(body, req) {
        return this.productService.newReserve(body, req.user.userId);
    }
    async getBidHistory(body, req) {
        return this.productService.bidHistory(body);
    }
    async getSecretHistory(body, req) {
        return this.productService.secretHistory(body);
    }
    async getBidReserve(body, req) {
        return this.productService.bidReserve(body, req.user.userId);
    }
    async addBanner(body, req) {
        return this.productService.addBanner(body);
    }
    async removeBanner(body, req) {
        return this.productService.removeBanner(body);
    }
    async homeBanner(body, req) {
        return this.productService.homeBanners(body);
    }
    async upcomingAuctions(body, req) {
        return this.productService.upcomingAuctions(body);
    }
    async liveAuctions(body, req) {
        return this.productService.liveAuctions(body);
    }
    async pastAuctions(body, req) {
        return this.productService.pastAuctions(body);
    }
    async switchLotAuction(body) {
        return this.productService.switchLotAuction(body);
    }
    async bulkUpdate(body) {
        return this.productService.bulkUpdate(body);
    }
    async deleteImage(body, req) {
        return await this.productService.deleteImage(body);
    }
    async getMyBids(body, req) {
        return this.productService.myBidHistory(body, req.user.userId);
    }
    async getMyDashboard(body, req) {
        return this.productService.myDashboard(body, req.user.userId);
    }
    async getAdjacentProductsBySku(body) {
        return this.productService.getAdjacentProductsBySku(body);
    }
    async getAllBids(body, req) {
        return this.productService.allBidHistory(body, req.user.userId);
    }
    async requestVideo(body, req) {
        return this.productService.requestVideo(body, req.user.userId);
    }
    async myrequestedVideo(body, req) {
        return this.productService.myrequestedVideo(body, req.user.userId);
    }
    async allrequestedVideo(body, req) {
        return this.productService.allrequestedVideo(body, req.user.userId);
    }
    async getCurrentAndNextLot() {
        return await this.productService.getCurrentAndNextLot();
    }
    async gethomeCurrentAndNextLot() {
        return await this.productService.gethomeCurrentAndNextLot();
    }
    async generateResult(body, req) {
        return await this.productService.generateResult(body, req.user.userId);
    }
    async getActiveLot() {
        return await this.productService.getActiveLot();
    }
    async getNextActiveLot() {
        return await this.productService.getNextLiveLot();
    }
    async lastResult() {
        return await this.productService.lastResult();
    }
    async getCart(body, req) {
        return await this.productService.getCart(req.user.userId);
    }
    async addToCart(body, req) {
        return await this.productService.addToCart(req.user.userId, body.productid, body.quantity);
    }
    async isProductInCart(body, req) {
        return await this.productService.isProductInCart(req.user.userId, body.productid);
    }
    async removeFromCart(body, req) {
        return await this.productService.removeFromCart(req.user.userId, body.productid);
    }
    async clearCart(body, req) {
        return await this.productService.clearCart(req.user.userId);
    }
    async changeManulStatus(body, req) {
        return await this.productService.changeManulStatus(body);
    }
};
exports.ProductController = ProductController;
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)(),
    (0, common_1.UsePipes)(new common_1.ValidationPipe({ transform: true })),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('images', 5, {
        storage: (0, multer_1.diskStorage)({
            destination: './uploads',
            filename: (req, file, cb) => {
                const uniqueSuffix = Date.now() + '-' + Math.round(Math.random() * 1e9);
                const ext = (0, path_1.extname)(file.originalname);
                cb(null, `${file.fieldname}-${uniqueSuffix}${ext}`);
            },
        }),
        fileFilter: (req, file, cb) => {
            if (!file.mimetype.match(/\/(jpg|jpeg|png|gif)$/)) {
                return cb(new common_1.BadRequestException('Only image files are allowed!'), false);
            }
            cb(null, true);
        },
    })),
    __param(0, (0, common_1.Body)()),
    __param(2, (0, common_1.UploadedFiles)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, product_dto_1.ProductDto, Array]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('all'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "findAll", null);
__decorate([
    (0, common_1.Post)('all/pages'),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pagination_query_dto_1.PaginationQueryDto]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getProducts", null);
__decorate([
    (0, common_1.Post)('all-products/pages'),
    __param(0, (0, common_1.Query)()),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pagination_query_dto_1.PaginationQueryDto]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getAllProducts", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Put)(':id'),
    (0, common_1.UsePipes)(new common_1.ValidationPipe({ transform: true })),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('images', 5, {
        storage: (0, multer_1.diskStorage)({
            destination: './uploads',
            filename: (req, file, cb) => {
                const uniqueSuffix = Date.now() + '-' + Math.round(Math.random() * 1e9);
                const ext = (0, path_1.extname)(file.originalname);
                cb(null, `${file.fieldname}-${uniqueSuffix}${ext}`);
            },
        }),
        fileFilter: (req, file, cb) => {
            if (!file.mimetype.match(/\/(jpg|jpeg|png|gif)$/)) {
                return cb(new common_1.BadRequestException('Only image files are allowed!'), false);
            }
            cb(null, true);
        },
    })),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __param(3, (0, common_1.UploadedFiles)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object, product_dto_1.ProductDto, Array]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "remove", null);
__decorate([
    (0, common_1.Post)('categories-with-count'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getCategoriesWithProductCount", null);
__decorate([
    (0, common_1.Post)('main-categories'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getMainCategoriesWithProductCount", null);
__decorate([
    (0, common_1.Post)('categories'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getProductsByCategory", null);
__decorate([
    (0, common_1.Post)('sku'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getProductBySKU", null);
__decorate([
    (0, common_1.Post)('sku-landing'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getProductBySKULanding", null);
__decorate([
    (0, common_1.Post)('lots/pages'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pagination_query_dto_1.PaginationQueryDto]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getProductByLots", null);
__decorate([
    (0, common_1.Post)('past-lots/pages'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pagination_query_dto_1.PaginationQueryDto]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getProductByPastLots", null);
__decorate([
    (0, common_1.Post)('store/pages'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pagination_query_dto_1.PaginationQueryDto]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getProductByStore", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('new-bid'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "postNewBid", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('new-reserve'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "postNewReserve", null);
__decorate([
    (0, common_1.Post)('get-bid'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getBidHistory", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('get-secret'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getSecretHistory", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('my-reserve'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getBidReserve", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('addbanner'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "addBanner", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('removebanner'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "removeBanner", null);
__decorate([
    (0, common_1.Post)('home-banners'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "homeBanner", null);
__decorate([
    (0, common_1.Post)('upcoming-auctions'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "upcomingAuctions", null);
__decorate([
    (0, common_1.Post)('live-auctions'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "liveAuctions", null);
__decorate([
    (0, common_1.Post)('past-auctions'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "pastAuctions", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('switch-lot-auction'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "switchLotAuction", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('bulk-update'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "bulkUpdate", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('delete-product-images'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "deleteImage", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('my-bids'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getMyBids", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('dashboard-counters'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getMyDashboard", null);
__decorate([
    (0, common_1.Post)('adjacent-products'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getAdjacentProductsBySku", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('all-bids'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getAllBids", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('request-video'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "requestVideo", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('my-video-requests'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "myrequestedVideo", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('all-video-requests'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "allrequestedVideo", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('current-and-next-lot'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getCurrentAndNextLot", null);
__decorate([
    (0, common_1.Post)('home-current-and-next-lot'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "gethomeCurrentAndNextLot", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('lot-bidding-result'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "generateResult", null);
__decorate([
    (0, common_1.Post)('active-lot'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getActiveLot", null);
__decorate([
    (0, common_1.Post)('next-live-lot'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getNextActiveLot", null);
__decorate([
    (0, common_1.Post)('last-result'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "lastResult", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('get-cart'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getCart", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('add-to-cart'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "addToCart", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('is-in-cart'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "isProductInCart", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('remove-from-cart'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "removeFromCart", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('clear-cart'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "clearCart", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('change-status-manually'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "changeManulStatus", null);
exports.ProductController = ProductController = __decorate([
    (0, common_1.Controller)('products'),
    __metadata("design:paramtypes", [product_service_1.ProductService])
], ProductController);
//# sourceMappingURL=product.controller.js.map