"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const mongoose_2 = require("mongoose");
const product_schema_1 = require("./schemas/product.schema");
const bid_schema_1 = require("./schemas/bid.schema");
const cart_schema_1 = require("./schemas/cart.schema");
const video_schema_1 = require("./schemas/video.schema");
const result_schema_1 = require("./schemas/result.schema");
const reserve_schema_1 = require("./schemas/reserve.schema");
const setting_schema_1 = require("../settings/setting.schema");
const user_schema_1 = require("../users/schemas/user.schema");
const email_service_1 = require("../email/email.service");
const axios = require('axios');
let ProductService = class ProductService {
    constructor(categoryModel, productModel, userModel, bidModel, cartModel, videoModel, resultModel, reserveModel, settingModel, emailService) {
        this.categoryModel = categoryModel;
        this.productModel = productModel;
        this.userModel = userModel;
        this.bidModel = bidModel;
        this.cartModel = cartModel;
        this.videoModel = videoModel;
        this.resultModel = resultModel;
        this.reserveModel = reserveModel;
        this.settingModel = settingModel;
        this.emailService = emailService;
    }
    async create(productDto) {
        try {
            const newProduct = new this.productModel(productDto);
            return await newProduct.save();
        }
        catch (error) {
            if (error.code === 11000) {
                throw new common_1.ConflictException('Product SKU already exists.');
            }
            throw new common_1.InternalServerErrorException(error);
        }
    }
    async findAll() {
        return this.productModel.find().populate('category').exec();
    }
    async findOne(id) {
        const product = await this.productModel.findById(id).populate('category').exec();
        if (!product) {
            throw new common_1.NotFoundException(`Product with id ${id} not found`);
        }
        return product;
    }
    async update(id, productDto, newImages) {
        const updatedProduct = await this.productModel.findByIdAndUpdate(id, productDto, { new: true }).exec();
        if (!updatedProduct) {
            throw new common_1.NotFoundException(`Product with id ${id} not found`);
        }
        return updatedProduct;
    }
    async updateWithImages(id, productDto, newImages) {
        const updatedProduct = await this.productModel.findByIdAndUpdate(id, {
            $set: productDto,
            ...(newImages.length > 0 && { $push: { images: { $each: newImages } } }),
        }, { new: true }).exec();
        if (!updatedProduct) {
            throw new common_1.NotFoundException(`Product with id ${id} not found`);
        }
        return updatedProduct;
    }
    async remove(id) {
        const result = await this.productModel.findByIdAndDelete(id).exec();
        if (!result) {
            throw new common_1.NotFoundException(`Product with id ${id} not found`);
        }
    }
    async getCategoriesWithProductCount() {
        return this.categoryModel.aggregate([
            {
                $lookup: {
                    from: 'products',
                    localField: '_id',
                    foreignField: 'category',
                    as: 'products',
                },
            },
            {
                $addFields: {
                    productCount: { $size: '$products' },
                },
            },
            {
                $project: {
                    products: 0,
                },
            },
        ]).exec();
    }
    async getMainCategoriesWithProductCount() {
        return this.categoryModel.aggregate([
            {
                $match: {
                    parent: 0,
                },
            },
            {
                $graphLookup: {
                    from: 'categories',
                    startWith: '$_id',
                    connectFromField: '_id',
                    connectToField: 'parent',
                    as: 'subcategories',
                },
            },
            {
                $lookup: {
                    from: 'products',
                    localField: '_id',
                    foreignField: 'category',
                    as: 'products',
                },
            },
            {
                $lookup: {
                    from: 'products',
                    localField: 'subcategories._id',
                    foreignField: 'category',
                    as: 'childProducts',
                },
            },
            {
                $addFields: {
                    productCount: {
                        $add: [
                            { $size: '$products' },
                            { $size: '$childProducts' },
                        ],
                    },
                },
            },
            {
                $project: {
                    products: 0,
                    childProducts: 0,
                    subcategories: 0,
                },
            },
        ]).exec();
    }
    async getProductsByCategory(name) {
        try {
            if (!name) {
                return this.productModel.find().populate('category').exec();
            }
            else {
                const category = await this.categoryModel.findOne({ name: name }).exec();
                if (!category) {
                    return [];
                }
                const products = await this.productModel.find({ category: category._id }).populate('category');
                return products;
            }
        }
        catch (error) {
            console.error('Error fetching products by category name:', error);
            throw error;
        }
    }
    async findBySKU(sku) {
        const product = await this.productModel
            .findOne({ sku })
            .populate('category')
            .exec();
        if (product && product.auctionStartDate) {
            const utcDate = product.auctionStartDate;
            const adjustedDate = new Date(utcDate.getTime() - (5 * 60 + 30) * 60 * 1000);
            product.auctionStartDate = adjustedDate;
        }
        return product;
    }
    async getProductBySKULanding(sku) {
        const product = await this.productModel
            .findOne({ sku })
            .populate('category')
            .exec();
        if (product && product.auctionStartDate) {
            const utcDate = product.auctionStartDate;
            const adjustedDate = new Date(utcDate.getTime() - (5 * 60 + 30) * 60 * 1000);
            product.auctionStartDate = adjustedDate;
        }
        return {
            statuscode: 'success',
            data: product,
            currenttime: new Date()
        };
    }
    async findByLots(paginationQuery) {
        var { page = 1, limit = 30, search, category } = paginationQuery;
        limit = 32;
        const skip = (page - 1) * limit;
        const cats = await this.categoryModel.findOne({ name: category }).exec();
        if (!cats) {
            const query = {};
            var escapedSearch = '';
            if (search) {
                escapedSearch = search.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
            }
            query.$and = [
                {
                    $or: [
                        { sku: { $regex: escapedSearch, $options: 'i' } },
                        { description: { $regex: escapedSearch, $options: 'i' } },
                        { shortDescription: { $regex: escapedSearch, $options: 'i' } },
                        { name: { $regex: escapedSearch, $options: 'i' } },
                        ...(isNaN(escapedSearch) ? [] : [{ lotNumber: { $eq: escapedSearch } }])
                    ]
                },
                { lotNumber: { $ne: null } },
                { auctionStartDate: { $ne: null } },
                { auctionEndDate: { $gt: new Date() } }
            ];
            const products = await this.productModel.find(query).skip(skip).limit(limit).populate('category').sort({ lotNumber: 1, _id: 1 }).exec();
            const total = await this.productModel.countDocuments(query).exec();
            return {
                data: products,
                total,
                page,
                limit,
                totalPages: Math.ceil(total / limit),
            };
        }
        else {
            const query = {};
            var escapedSearch = '';
            if (search) {
                escapedSearch = search.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
            }
            const categoryId = cats._id;
            const categories = await this.categoryModel
                .find({ $or: [{ _id: categoryId }, { parent: categoryId }] })
                .exec();
            const categoryIds = categories.map(category => category._id);
            query.$and = [
                {
                    $or: [
                        { sku: { $regex: escapedSearch, $options: 'i' } },
                        { description: { $regex: escapedSearch, $options: 'i' } },
                        { shortDescription: { $regex: escapedSearch, $options: 'i' } },
                        { name: { $regex: escapedSearch, $options: 'i' } },
                        ...(isNaN(escapedSearch) ? [] : [{ lotNumber: { $eq: escapedSearch } }])
                    ]
                },
                { lotNumber: { $ne: null } },
                { auctionStartDate: { $ne: null } },
                { category: { $in: categoryIds } },
                { auctionEndDate: { $gt: new Date() } }
            ];
            const products = await this.productModel.find(query).skip(skip).limit(limit).populate('category').sort({ lotNumber: 1, _id: 1 }).exec();
            const total = await this.productModel.countDocuments(query).exec();
            return {
                data: products,
                total,
                page,
                limit,
                totalPages: Math.ceil(total / limit),
            };
        }
    }
    async findByPastLots(paginationQuery) {
        var { page = 1, limit = 30, search, category, auction = '0' } = paginationQuery;
        limit = 32;
        const skip = (page - 1) * limit;
        const cats = await this.categoryModel.findOne({ name: category }).exec();
        var auctionStart = new Date('2025-01-01');
        ;
        var auctionEnd = new Date();
        if (auction == '1') {
            var auctionStart = new Date('2025-01-15');
            var auctionEnd = new Date('2025-02-10');
        }
        if (auction == '2') {
            var auctionStart = new Date('2025-06-01');
            var auctionEnd = new Date('2025-06-16');
        }
        if (!cats) {
            const query = {};
            var escapedSearch = '';
            if (search) {
                escapedSearch = search.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
            }
            query.$and = [
                {
                    $or: [
                        { sku: { $regex: escapedSearch, $options: 'i' } },
                        { description: { $regex: escapedSearch, $options: 'i' } },
                        { shortDescription: { $regex: escapedSearch, $options: 'i' } },
                        { name: { $regex: escapedSearch, $options: 'i' } },
                        ...(isNaN(escapedSearch) ? [] : [{ lotNumber: { $eq: escapedSearch } }])
                    ]
                },
                { lotNumber: { $ne: null } },
                { auctionStartDate: { $ne: null, $gte: auctionStart } },
                { auctionEndDate: { $lte: auctionEnd } }
            ];
            const products = await this.productModel.find(query).skip(skip).limit(limit).populate('category').sort({ lotNumber: 1, _id: 1 }).exec();
            const total = await this.productModel.countDocuments(query).exec();
            return {
                data: products,
                total,
                page,
                limit,
                totalPages: Math.ceil(total / limit),
            };
        }
        else {
            const query = {};
            var escapedSearch = '';
            if (search) {
                escapedSearch = search.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
            }
            const categoryId = cats._id;
            const categories = await this.categoryModel
                .find({ $or: [{ _id: categoryId }, { parent: categoryId }] })
                .exec();
            const categoryIds = categories.map(category => category._id);
            query.$and = [
                {
                    $or: [
                        { sku: { $regex: escapedSearch, $options: 'i' } },
                        { description: { $regex: escapedSearch, $options: 'i' } },
                        { shortDescription: { $regex: escapedSearch, $options: 'i' } },
                        { name: { $regex: escapedSearch, $options: 'i' } },
                        ...(isNaN(escapedSearch) ? [] : [{ lotNumber: { $eq: escapedSearch } }])
                    ]
                },
                { lotNumber: { $ne: null } },
                { category: { $in: categoryIds } },
                { auctionStartDate: { $ne: null, $gte: auctionStart } },
                { auctionEndDate: { $lte: auctionEnd } }
            ];
            const products = await this.productModel.find(query).skip(skip).limit(limit).populate('category').sort({ lotNumber: 1, _id: 1 }).exec();
            const total = await this.productModel.countDocuments(query).exec();
            return {
                data: products,
                total,
                page,
                limit,
                totalPages: Math.ceil(total / limit),
            };
        }
    }
    async getProductByStore(paginationQuery) {
        var { page = 1, limit = 30, search, category } = paginationQuery;
        limit = 32;
        const skip = (page - 1) * limit;
        const query = {};
        var escapedSearch = '';
        if (search) {
            escapedSearch = search.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
        }
        query.$and = [
            {
                $or: [
                    { sku: { $regex: escapedSearch, $options: 'i' } },
                    { description: { $regex: escapedSearch, $options: 'i' } },
                    { shortDescription: { $regex: escapedSearch, $options: 'i' } },
                    { name: { $regex: escapedSearch, $options: 'i' } },
                    ...(isNaN(escapedSearch) ? [] : [{ lotNumber: { $eq: escapedSearch } }])
                ]
            },
            { auctionStartDate: null },
        ];
        const products = await this.productModel.find(query).skip(skip).limit(limit).populate('category').sort({ lotNumber: 1 }).exec();
        const total = await this.productModel.countDocuments(query).exec();
        return {
            data: products,
            total,
            page,
            limit,
            totalPages: Math.ceil(total / limit),
        };
    }
    async bidHistory(body) {
        const product = await this.productModel.findById(body.productid).exec();
        if (product) {
            const startPrice = product.startPrice ? product.startPrice : 1;
            const maxBid = await this.bidModel
                .find({ product: body.productid })
                .sort({ bidAmount: -1 })
                .limit(1)
                .exec();
            const currentMaxBidAmount = maxBid.length > 0 ? maxBid[0].bidAmount : startPrice;
            const currentMaxBidUser = maxBid.length > 0 ? maxBid[0].user : '';
            const setting = await this.settingModel.findOne({
                fromamount: { $lte: currentMaxBidAmount },
                toamount: { $gte: currentMaxBidAmount },
            });
            const bidIncrement = setting ? setting.bidincrement : 0;
            const nextBidAmount = currentMaxBidAmount + bidIncrement;
            if (maxBid.length > 0) {
                return {
                    statuscode: 'success',
                    currentBid: currentMaxBidAmount,
                    nextBid: nextBidAmount,
                    currentBidUser: currentMaxBidUser,
                    bid: await this.bidModel.find({ product: body.productid }).populate('user').sort({ bidAmount: -1 }).exec(),
                    currenttime: new Date()
                };
            }
            else {
                return {
                    statuscode: 'success',
                    currentBid: 0,
                    nextBid: currentMaxBidAmount,
                    currentBidUser: currentMaxBidUser,
                    bid: await this.bidModel.find({ product: body.productid }).populate('user').sort({ bidAmount: -1 }).exec(),
                    currenttime: new Date()
                };
            }
        }
        else {
            return {
                statuscode: 'failure',
                message: 'Invalid Product Request',
            };
        }
    }
    async secretHistory(body) {
        const highestReserve = await this.reserveModel
            .find({ product: body.productid })
            .populate('user')
            .sort({ reserveAmount: -1 })
            .exec();
        return {
            statuscode: 'success',
            secret: highestReserve,
        };
    }
    async bidReserve(body, id) {
        const highestReserve = await this.reserveModel
            .findOne({ product: body.productid, user: id })
            .sort({ reserveAmount: -1 })
            .exec();
        return {
            statuscode: 'success',
            secret: highestReserve,
        };
    }
    async newBid(body, user) {
        const userdata = await this.userModel.findById(user).exec();
        const usermaxbidamount = userdata.maxBidAmount ? userdata.maxBidAmount : 0;
        const productId = body.productid;
        var amount = body.amount;
        if (userdata.status == 0) {
            return {
                statuscode: 'failure',
                message: 'Your maximum bid limit is yet to be approved by admin. Please contact administrator',
            };
        }
        else {
            const product = await this.productModel.findById(body.productid).exec();
            if (product) {
                const startPrice = product.startPrice ? product.startPrice : 1;
                const currentTime = new Date();
                if (currentTime > product.auctionEndDate) {
                    return {
                        statuscode: 'failure',
                        message: 'Bidding time is over',
                    };
                }
                if (product.auctionStatus != '0') {
                    return {
                        statuscode: 'failure',
                        message: 'Auction ended for this product.',
                    };
                }
                const maxBid = await this.bidModel
                    .find({ product: body.productid })
                    .sort({ bidAmount: -1 })
                    .limit(1)
                    .exec();
                if (amount == undefined && body.secret > 0) {
                    amount = body.secret;
                }
                if (maxBid.length > 0 && maxBid[0].user.toString() === user.toString()) {
                    console.log("should not add bid");
                    return {
                        statuscode: 'failure',
                        message: 'You are highest bidder now.',
                    };
                }
                if (maxBid.length > 0 && maxBid[0].bidAmount >= amount) {
                    return {
                        statuscode: 'failure',
                        message: 'This bid amount already exists.',
                    };
                }
                var currentMaxBidAmount = maxBid.length > 0 ? maxBid[0].bidAmount : startPrice;
                const setting = await this.settingModel.findOne({
                    fromamount: { $lte: currentMaxBidAmount },
                    toamount: { $gte: currentMaxBidAmount },
                });
                const bidIncrement = setting ? setting.bidincrement : 0;
                if (maxBid.length > 0) {
                    var nextBidAmount = currentMaxBidAmount + bidIncrement;
                }
                else {
                    var nextBidAmount = currentMaxBidAmount;
                }
                var myreserve = await this.reserveModel
                    .findOne({ product: productId, user: user })
                    .sort({ reserveAmount: -1 })
                    .select('_id user reserveAmount product createdAt')
                    .exec();
                var highestReserve = await this.reserveModel
                    .findOne({ product: productId })
                    .sort({ reserveAmount: -1 })
                    .select('user reserveAmount')
                    .exec();
                var isMyReserveHighest = true;
                if (myreserve && highestReserve) {
                    isMyReserveHighest = highestReserve && highestReserve.reserveAmount === myreserve.reserveAmount && highestReserve.user.toString() === user.toString();
                }
                else {
                    isMyReserveHighest = true;
                }
                var customreserveAmount = '';
                var sameReserveLater = '';
                if (myreserve) {
                    sameReserveLater = await this.reserveModel.findOne({
                        product: productId,
                        reserveAmount: myreserve.reserveAmount,
                        createdAt: { $gt: myreserve.createdAt },
                        user: { $ne: user },
                    });
                }
                if (sameReserveLater && myreserve.reserveAmount >= nextBidAmount) {
                    nextBidAmount = myreserve.reserveAmount;
                }
                if (maxBid.length > 0 && maxBid[0].user == user) {
                    var otherhighestReserve = await this.reserveModel
                        .findOne({
                        product: productId,
                        user: { $ne: user },
                    })
                        .sort({ reserveAmount: -1 })
                        .select('user reserveAmount')
                        .exec();
                    if (otherhighestReserve) {
                        if (maxBid[0].bidAmount >= otherhighestReserve.reserveAmount) {
                            return {
                                statuscode: 'failure',
                                message: 'You are the highest bidder now. We will let you know if you are outbidden and you may place your bid then.',
                            };
                        }
                    }
                    else {
                        return {
                            statuscode: 'failure',
                            message: 'You are the highest bidder now. We will let you know if you are outbidden and you may place your bid then.',
                        };
                    }
                }
                if (usermaxbidamount < nextBidAmount) {
                    return {
                        statuscode: 'failure',
                        message: 'Your maximum bid limit is less than next bid amount',
                    };
                }
                else {
                    if (product.lotstart == '1') {
                        const extendAuctionForSeconds = product.extendAuctionForSeconds || 20;
                        const lastBid = await this.bidModel.find({ product: productId, createdAt: { $gt: product.productDate } })
                            .sort({ createdAt: -1 })
                            .limit(1)
                            .exec();
                        if (lastBid.length > 0) {
                            const lastBidTime = new Date(lastBid[0].createdAt);
                            const timeDifference = (currentTime.getTime() - lastBidTime.getTime()) / 1000;
                            if (timeDifference > extendAuctionForSeconds) {
                                if (lastBid[0].bidAmount < product.reservePrice) {
                                    await this.productModel.findByIdAndUpdate(productId, { auctionStatus: '-1' });
                                    return {
                                        statuscode: 'failure',
                                        message: 'Auction has ended without being sold',
                                        bid: await this.bidModel.find({ product: body.productid }).populate('user').exec(),
                                    };
                                }
                                else {
                                    await this.productModel.findByIdAndUpdate(productId, {
                                        $set: { finaluser: lastBid[0].user },
                                        $currentDate: { productDate: true }
                                    });
                                    await this.productModel.findByIdAndUpdate(productId, {
                                        $set: { finalamount: lastBid[0].bidAmount },
                                        $currentDate: { productDate: true }
                                    });
                                    await this.productModel.findByIdAndUpdate(productId, {
                                        $set: { auctionStatus: '1' },
                                        $currentDate: { productDate: true }
                                    });
                                    return {
                                        statuscode: 'failure',
                                        message: `Bidding has ended for this product due to inactivity for more than ${extendAuctionForSeconds} seconds`,
                                    };
                                }
                            }
                            else {
                                var checkmaxBid = await this.bidModel
                                    .find({ product: body.productid })
                                    .sort({ bidAmount: -1 })
                                    .limit(1)
                                    .exec();
                                if (checkmaxBid.length > 0 && checkmaxBid[0].bidAmount >= amount) {
                                    return {
                                        statuscode: 'failure',
                                        message: 'This bid amount already exists.',
                                    };
                                }
                                if (checkmaxBid.length > 0 && checkmaxBid[0].user.toString() === user.toString()) {
                                    console.log("should not add bid");
                                    return {
                                        statuscode: 'failure',
                                        message: 'You are highest bidder now.',
                                    };
                                }
                                var againhighestReserve = await this.reserveModel
                                    .findOne({ product: productId })
                                    .sort({ reserveAmount: -1 })
                                    .select('user reserveAmount')
                                    .exec();
                                console.log("highest reserve" + againhighestReserve);
                                if (checkmaxBid.length > 0 && checkmaxBid[0].user != user) {
                                    var result = await this.bidModel.findOneAndUpdate({ product: productId, bidAmount: nextBidAmount }, { $setOnInsert: { user: user, timestamps: currentTime, remark: 'added from line 825' } }, { upsert: true, new: true });
                                }
                                if (checkmaxBid.length == 0) {
                                    var result = await this.bidModel.findOneAndUpdate({ product: productId, bidAmount: nextBidAmount }, { $setOnInsert: { user: user, timestamps: currentTime, remark: 'added from line 833' } }, { upsert: true, new: true });
                                }
                                if (againhighestReserve && againhighestReserve.reserveAmount >= amount) {
                                    console.log("Reserve price > current bid(" + amount + ") with next bid amount as " + nextBidAmount);
                                    var checkmax2Bid = await this.bidModel
                                        .find({ product: body.productid })
                                        .sort({ bidAmount: -1 })
                                        .limit(1)
                                        .exec();
                                    var current2MaxBidAmount = checkmax2Bid.length > 0 ? checkmax2Bid[0].bidAmount : startPrice;
                                    const setting2 = await this.settingModel.findOne({
                                        fromamount: { $lte: current2MaxBidAmount },
                                        toamount: { $gte: current2MaxBidAmount },
                                    });
                                    const bid2Increment = setting ? setting.bidincrement : 0;
                                    if (checkmax2Bid.length > 0) {
                                        var next2BidAmount = current2MaxBidAmount + bid2Increment;
                                    }
                                    else {
                                        var next2BidAmount = current2MaxBidAmount;
                                    }
                                    var result = await this.bidModel.findOneAndUpdate({ product: productId, bidAmount: next2BidAmount }, { $setOnInsert: { user: againhighestReserve.user, timestamps: currentTime, remark: 'added from line 864' } }, { upsert: true, new: true });
                                }
                                else {
                                    if (checkmaxBid[0].user == user) {
                                        return {
                                            statuscode: 'failure',
                                            message: 'You are the highest bidder now. We will let you know if you are outbidden and you may place your bid then.',
                                        };
                                    }
                                    else {
                                        console.log("final bid from here");
                                    }
                                }
                                if (result.user.toString() != user.toString()) {
                                    return {
                                        statuscode: 'failure',
                                        message: `Bid already exists with Same Amount. Please try again.`,
                                    };
                                }
                                else {
                                    await this.productModel.findByIdAndUpdate(productId, { productDate: currentTime });
                                }
                                this.alertLastBidder(productId);
                                await this.alertCurrentBidder(productId);
                                return {
                                    statuscode: 'success',
                                    message: 'Bid placed successfully',
                                    bid: await this.bidModel.find({ product: body.productid }).populate('user').exec(),
                                };
                            }
                        }
                        else {
                            const lastBidTime = new Date(product.productDate);
                            const timeDifference = (currentTime.getTime() - lastBidTime.getTime()) / 1000;
                            if (timeDifference > extendAuctionForSeconds) {
                                await this.productModel.findByIdAndUpdate(productId, { auctionStatus: '-1' });
                                return {
                                    statuscode: 'failure',
                                    message: 'Bidding period has ended for this product due to inactivity for more than ' + extendAuctionForSeconds + ' seconds',
                                };
                            }
                            else {
                                var checkmaxBidagain = await this.bidModel
                                    .find({ product: body.productid })
                                    .sort({ bidAmount: -1 })
                                    .limit(1)
                                    .exec();
                                if (checkmaxBidagain.length > 0 && checkmaxBidagain[0].bidAmount >= amount) {
                                    return {
                                        statuscode: 'failure',
                                        message: 'This bid amount already exists.',
                                    };
                                }
                                var result = await this.bidModel.findOneAndUpdate({ product: productId, bidAmount: nextBidAmount }, { $setOnInsert: { user: user, timestamps: currentTime, remark: 'this is from line 946' } }, { upsert: true, new: true });
                                var inliveagainhighestReserve = await this.reserveModel
                                    .findOne({ product: productId })
                                    .sort({ reserveAmount: -1 })
                                    .select('user reserveAmount')
                                    .exec();
                                console.log("line 957");
                                console.log(inliveagainhighestReserve);
                                console.log(nextBidAmount);
                                if (inliveagainhighestReserve && inliveagainhighestReserve.reserveAmount >= nextBidAmount) {
                                    console.log("line 963");
                                    console.log(inliveagainhighestReserve.reserveAmount);
                                    console.log(nextBidAmount);
                                    const livesetting = await this.settingModel.findOne({
                                        fromamount: { $lte: nextBidAmount },
                                        toamount: { $gte: nextBidAmount },
                                    });
                                    const livebidIncrement = livesetting ? livesetting.bidincrement : 0;
                                    var livenextBidAmount = nextBidAmount + livebidIncrement;
                                    if (inliveagainhighestReserve.reserveAmount >= nextBidAmount) {
                                        var bidfindresult = await this.bidModel.findOneAndUpdate({ product: productId, bidAmount: livenextBidAmount }, { $setOnInsert: { user: inliveagainhighestReserve.user, timestamps: currentTime, remark: 'this is from line 962' } }, { upsert: true, new: true });
                                    }
                                }
                                if (result.user.toString() != user.toString()) {
                                    return {
                                        statuscode: 'failure',
                                        message: `Bid already exists with Same Amount. Please try again.`,
                                    };
                                }
                                else {
                                    await this.productModel.findByIdAndUpdate(productId, { productDate: currentTime });
                                }
                                this.alertLastBidder(productId);
                                await this.alertCurrentBidder(productId);
                                return {
                                    statuscode: 'success',
                                    message: 'Bid placed successfully',
                                };
                            }
                        }
                    }
                    else {
                        var checkmaxBidagainsecond = await this.bidModel
                            .find({ product: body.productid })
                            .sort({ bidAmount: -1 })
                            .limit(1)
                            .exec();
                        if (checkmaxBidagainsecond.length > 0 && checkmaxBidagainsecond[0].bidAmount >= amount) {
                            return {
                                statuscode: 'failure',
                                message: 'This bid amount already exists.',
                            };
                        }
                        if (checkmaxBidagainsecond.length > 0 && checkmaxBidagainsecond[0].user.toString() === user.toString()) {
                            console.log("again should not add bid");
                            return {
                                statuscode: 'failure',
                                message: 'You are highest bidder now.',
                            };
                        }
                        var againhighestReserve = await this.reserveModel
                            .findOne({ product: productId })
                            .sort({ reserveAmount: -1 })
                            .select('user reserveAmount')
                            .exec();
                        if (againhighestReserve && againhighestReserve.reserveAmount >= amount) {
                            const finalsetting = await this.settingModel.findOne({
                                fromamount: { $lte: nextBidAmount },
                                toamount: { $gte: nextBidAmount },
                            });
                            const finalbidIncrement = finalsetting ? finalsetting.bidincrement : 0;
                            var bidfindresult = await this.bidModel.findOneAndUpdate({ product: productId, bidAmount: nextBidAmount }, { $setOnInsert: { user: againhighestReserve.user, timestamps: currentTime, remark: 'this is from line 1026' } }, { upsert: true, new: true });
                        }
                        else {
                            var bidfindresult = await this.bidModel.findOneAndUpdate({ product: productId, bidAmount: nextBidAmount }, { $setOnInsert: { user: user, timestamps: currentTime, remark: 'this is from line 1007' } }, { upsert: true, new: true });
                        }
                        if (bidfindresult.user.toString() != user.toString()) {
                            return {
                                statuscode: 'failure',
                                message: `Bid already exists with Same Amount. Please try again.`,
                            };
                        }
                        else {
                            await this.productModel.findByIdAndUpdate(productId, { productDate: currentTime });
                        }
                        this.alertLastBidder(productId);
                        const result = await this.reserveModel
                            .findOne({ product: productId })
                            .sort({ reserveAmount: -1 })
                            .select('_id user reserveAmount product')
                            .exec();
                        if (result && result.reserveAmount > nextBidAmount) {
                            var nextReserve = await this.reserveModel
                                .find({ product: productId })
                                .sort({ reserveAmount: -1 })
                                .skip(1)
                                .limit(1)
                                .exec();
                            if (nextReserve.length > 0 && nextReserve[0].reserveAmount > nextBidAmount) {
                                nextBidAmount = nextReserve[0].reserveAmount;
                                var newsetting = await this.settingModel.findOne({
                                    fromamount: { $lte: nextBidAmount },
                                    toamount: { $gte: nextBidAmount },
                                });
                                var newbidIncrement = newsetting ? newsetting.bidincrement : 0;
                                var newnextBidAmount = nextBidAmount + newbidIncrement;
                                if (result.reserveAmount >= newnextBidAmount) {
                                    const morenewBid = new this.bidModel({
                                        user: result.user,
                                        product: result.product,
                                        bidAmount: newnextBidAmount,
                                        timestamps: currentTime,
                                    });
                                    await morenewBid.save();
                                    this.alertLastBidder(result.product);
                                }
                            }
                        }
                        await this.alertCurrentBidder(productId);
                        return {
                            statuscode: 'success',
                            message: 'Bid placed successfully',
                        };
                    }
                }
            }
            else {
                return {
                    statuscode: 'failure',
                    message: 'Invalid Product Request',
                };
            }
        }
    }
    async alertLastBidder(productId) {
        const lastbid = await this.bidModel
            .find({ product: productId })
            .sort({ createdAt: -1 })
            .skip(1)
            .limit(1)
            .exec();
        if (lastbid.length > 0) {
            const userdata = await this.userModel.findById(lastbid[0].user).exec();
            const productdata = await this.productModel.findById(productId).exec();
            const highestBid = await this.bidModel
                .find({ product: productId })
                .sort({ createdAt: -1 })
                .limit(1)
                .exec();
            var plain = "Dear " + userdata.firstname + ' ' + userdata.lastname + ", Your Bid was Outbid - Place a New Bid Now! You're still in the Auction! Don't Miss out on the opportunity to win this item. Place a new bid now to stay ahead!";
            var content = "<p>Dear " + userdata.firstname + ' ' + userdata.lastname + ",</p> <br><p>You’ve been outbid on Lot #" + productdata.lotNumber + " – " + productdata.name + ".</p><br><p>&#9888;&#65039; <strong>Highest Bid Now:</strong> ₹" + highestBid[0].bidAmount + "</p><p>&#9989; <Strong>Your Bid:</strong> " + lastbid[0].bidAmount + "</p><br><p>Don’t miss your chance! Place a higher bid before the auction ends:</p><br><p>&#128073; <a href='https://travancoreheritageauction.com/product-view/" + productdata.sku + "'>Place a New Bid Now</a></p><br><p><Strong>Good luck!</strong></p><p>Travancore Heritage Auction Team</p>";
            var subject = "You’ve Been Outbid on Lot #" + productdata.lotNumber + " – Place a New Bid Now!";
            this.sendEmail(userdata.email, userdata.firstname + ' ' + userdata.lastname, plain, content, subject);
        }
    }
    async alertCurrentBidder(productId) {
        const lastbid = await this.bidModel
            .find({ product: productId })
            .sort({ createdAt: -1 })
            .limit(1)
            .exec();
        if (lastbid.length > 0) {
            const userdata = await this.userModel.findById(lastbid[0].user).exec();
            const productdata = await this.productModel.findById(productId).exec();
            var plain = "Dear Admin, Mr " + userdata.firstname + ' ' + userdata.lastname + ", has successfully placed a bid for the following item. Cust ID: THA" + userdata.regno + ", Lot Number: " + productdata.lotNumber + ", Bid Value: " + lastbid[0].bidAmount;
            var content = "<p>Dear Admin, Mr " + userdata.firstname + ' ' + userdata.lastname + ", has successfully placed a bid for the following item.</p><br><p>Cust ID: THA" + userdata.regno + "</p><br><p>Lot Number: " + productdata.lotNumber + "</p><br><p>Bid Value: " + lastbid[0].bidAmount + "</p>";
            var subject = "New Bid From Customer - Travancore Heritage Auction";
            this.sendEmail('travancoreheritageauction@gmail.com', userdata.firstname + ' ' + userdata.lastname, plain, content, subject);
            const wresponse = await axios.post('https://graph.facebook.com/v23.0/709680682221149/messages', {
                messaging_product: 'whatsapp',
                to: '918848044033',
                type: 'template',
                template: {
                    name: 'new_bid_placed_admin_notification_new',
                    language: {
                        code: 'en',
                    },
                    components: [
                        {
                            type: 'body',
                            parameters: [
                                {
                                    type: 'text',
                                    parameter_name: 'name',
                                    text: userdata.firstname + ' ' + userdata.lastname,
                                },
                                {
                                    type: 'text',
                                    parameter_name: 'id',
                                    text: userdata.regno,
                                },
                                {
                                    type: 'text',
                                    parameter_name: 'number',
                                    text: userdata.phone,
                                },
                                {
                                    type: 'text',
                                    parameter_name: 'bidamount',
                                    text: lastbid[0].bidAmount,
                                },
                                {
                                    type: 'text',
                                    parameter_name: 'lotnumber',
                                    text: productdata.lotNumber,
                                },
                                {
                                    type: 'text',
                                    parameter_name: 'itemname',
                                    text: productdata.name,
                                },
                            ],
                        },
                    ],
                },
            }, {
                headers: {
                    'Content-Type': 'application/json',
                    Authorization: 'Bearer EAAFVXw8ns9ABO7hGWIU57K1PZBOlvDtylqUt8AfVF5AXt5i8aTZAa2qeqcVpE9eorejrLggCrIgBau77usFS7CZAZAtXxyl2RK9Mh4Qhw4ZBPUq6s4ArkvM8VfPVnNm58ua6jXhOTzhfqCcrSzPzpjpSniq36tGKICBxqEjJfqSfK68Vqbb0stCuORwOd6kGEHGCPFHOIQlsiC9R2FDXdGHxpZBZBXTZCEcyrU4nw1wLugnjS5T2OtvIhjYZB00EiZAV6I2sjsEuvC5QZDZD',
                },
            });
        }
    }
    async sendEmail(to, name, plain, content, subject) {
        const mailjetAPIKey = 'a827249b18ef476acc5eb882fca8c1dd';
        const mailjetAPISecret = '8fb49d646c35592d0814f9ae7da771c4';
        const mailData = {
            Messages: [
                {
                    From: {
                        Email: "info@travancoreheritageauction.com",
                        Name: "Travancore Heritage Auction"
                    },
                    To: [
                        {
                            Email: to,
                            Name: name
                        }
                    ],
                    Subject: subject,
                    TextPart: plain,
                    HTMLPart: content
                }
            ]
        };
        try {
            const response = await axios.post('https://api.mailjet.com/v3.1/send', mailData, {
                headers: { 'Content-Type': 'application/json' },
                auth: {
                    username: mailjetAPIKey,
                    password: mailjetAPISecret
                }
            });
            return 1;
        }
        catch (error) {
            return 2;
        }
    }
    ;
    async newReserve(body, user) {
        const userdata = await this.userModel.findById(user).exec();
        const usermaxbidamount = userdata.maxBidAmount ? userdata.maxBidAmount : 0;
        const productId = body.productid;
        const secretamount = body.secret;
        if (userdata.status == 0) {
            return {
                statuscode: 'failure',
                message: 'Your maximum bid limit is yet to be approved by admin. Please contact administrator',
            };
        }
        else {
            const product = await this.productModel.findById(body.productid).exec();
            if (product) {
                const startPrice = product.startPrice ? product.startPrice : 1;
                const currentTime = new Date();
                if (currentTime > product.auctionEndDate) {
                    return {
                        statuscode: 'failure',
                        message: 'Bidding time is over',
                    };
                }
                if (secretamount < startPrice) {
                    return {
                        statuscode: 'failure',
                        message: 'Secret Amount should be atleast the Minimum Bid of the Product',
                    };
                }
                const maxBid = await this.bidModel
                    .find({ product: body.productid })
                    .sort({ bidAmount: -1 })
                    .limit(1)
                    .exec();
                const currentMaxBidAmount = maxBid.length > 0 ? maxBid[0].bidAmount : startPrice;
                const setting = await this.settingModel.findOne({
                    fromamount: { $lte: currentMaxBidAmount },
                    toamount: { $gte: currentMaxBidAmount },
                });
                const bidIncrement = setting ? setting.bidincrement : 0;
                var nextBidAmount = maxBid.length > 0
                    ? currentMaxBidAmount + bidIncrement
                    : currentMaxBidAmount;
                if (secretamount < nextBidAmount) {
                    return {
                        statuscode: 'failure',
                        message: 'Secret Amount should be greater than the next Bid amount of the Product',
                    };
                }
                if (usermaxbidamount <= nextBidAmount) {
                    return {
                        statuscode: 'failure',
                        message: 'Your maximum bid limit is less than next bid amount based on current secret bid. So your secret bid could not be placed.',
                    };
                }
                else {
                    let placeNewBid = false;
                    let bidUser = null;
                    var maxReserveDetails = await this.reserveModel
                        .find({ product: body.productid })
                        .sort({ reserveAmount: -1 })
                        .limit(1)
                        .exec();
                    const newReserve = new this.reserveModel({
                        user: user,
                        product: productId,
                        reserveAmount: secretamount,
                        timestamps: currentTime,
                    });
                    await newReserve.save();
                    if (maxReserveDetails.length > 0) {
                        if (secretamount <= maxReserveDetails[0].reserveAmount && user != maxReserveDetails[0].user) {
                            placeNewBid = true;
                            bidUser = maxReserveDetails[0].user;
                        }
                        else {
                            if (secretamount >= nextBidAmount) {
                                placeNewBid = true;
                                bidUser = user;
                            }
                        }
                    }
                    else {
                        if (secretamount >= nextBidAmount) {
                            placeNewBid = true;
                            bidUser = user;
                        }
                    }
                    if (placeNewBid) {
                        var reservebidresult = await this.newBid(body, bidUser);
                    }
                    const updatedProduct = await this.productModel.findOneAndUpdate({
                        _id: productId,
                        $or: [
                            { userReservePrice: { $lt: secretamount } },
                            { userReservePrice: { $exists: false } },
                        ],
                    }, {
                        userReservePrice: secretamount,
                    }, {
                        new: true,
                        fields: { userReservePrice: 1 },
                    });
                    console.log("1");
                    console.log(updatedProduct);
                    if (updatedProduct) {
                        console.log("reurning 2");
                        return {
                            statuscode: 'success',
                            message: 'Secret Maximum Bid placed successfully.',
                            bid: await this.bidModel
                                .find({ product: body.productid })
                                .populate('user')
                                .exec(),
                            secret: updatedProduct.userReservePrice,
                        };
                    }
                    else {
                        var highestReserve = await this.reserveModel
                            .findOne({ product: body.productid })
                            .sort({ reserveAmount: -1 })
                            .select('user reserveAmount')
                            .exec();
                        if (user != highestReserve.user) {
                            var reservebidresult = await this.newBid(body, highestReserve.user);
                            return {
                                statuscode: 'success',
                                message: 'Secret Maximum Bid could not be placed as someone has placed higher secret bid.',
                                bid: await this.bidModel
                                    .find({ product: body.productid })
                                    .populate('user')
                                    .exec(),
                                secret: 0,
                                hig: highestReserve,
                            };
                        }
                        else {
                            return {
                                statuscode: 'success',
                                message: 'Secret bid Placed.',
                                bid: await this.bidModel
                                    .find({ product: body.productid })
                                    .populate('user')
                                    .exec(),
                                secret: 0,
                                hig: highestReserve,
                            };
                        }
                    }
                }
            }
            else {
                return {
                    statuscode: 'failure',
                    message: 'Invalid Product Request',
                };
            }
        }
    }
    async addBanner(body) {
        await this.productModel.findByIdAndUpdate(body.id, { isbanner: 'yes' });
        return {
            statuscode: 'success',
            message: 'Product will be available in Home Banner',
        };
    }
    async removeBanner(body) {
        await this.productModel.findByIdAndUpdate(body.id, { isbanner: 'no' });
        return {
            statuscode: 'success',
            message: 'Product will be removed from Home Banner',
        };
    }
    async homeBanners(body) {
        return this.productModel.find({ isbanner: 'yes' }).populate('category').exec();
    }
    async upcomingAuctions(body) {
        const today = new Date();
        today.setHours(0, 0, 0, 0);
        return await this.productModel
            .find({
            $and: [
                { auctionStartDate: { $gt: today } },
                { lotNumber: { $ne: null } }
            ]
        })
            .populate('category')
            .limit(6)
            .exec();
    }
    async liveAuctions(body) {
        const today = new Date();
        today.setHours(0, 0, 0, 0);
        const tomorrow = new Date(today);
        tomorrow.setDate(tomorrow.getDate() + 1);
        return this.productModel
            .find({
            $and: [
                { auctionStartDate: { $lt: tomorrow } },
                { auctionEndDate: { $gte: today } },
                { lotNumber: { $ne: null } }
            ]
        })
            .populate('category')
            .limit(6)
            .exec();
    }
    async pastAuctions(body) {
        const today = new Date();
        today.setHours(0, 0, 0, 0);
        return this.productModel
            .find({
            $and: [
                { auctionEndDate: { $lt: today } },
                { lotNumber: { $ne: null } }
            ]
        })
            .populate('category')
            .limit(6)
            .exec();
    }
    async switchLotAuction(body) {
        const product = await this.productModel.findById(body.id).exec();
        if (!product) {
            throw new Error('Product not found');
        }
        const newLotStart = body.status == '0' ? 1 : 0;
        const updatedProduct = await this.productModel.findByIdAndUpdate(body.id, {
            $set: { lotstart: product.lotstart !== undefined ? newLotStart : 0 },
            $currentDate: {
                productDate: true
            }
        }, { new: true, upsert: true });
        return {
            statuscode: 'success',
            message: 'LOT Status Updated.',
            data: updatedProduct
        };
    }
    async bulkUpdate(body) {
        const filter = {};
        const update = { $set: { auctionStartDate: body.auctionStartDate } };
        const result = await this.productModel.updateMany(filter, update);
        return result;
    }
    async findAllPages(paginationQuery) {
        const { page = 1, limit = 10, search } = paginationQuery;
        const skip = (page - 1) * limit;
        const query = {};
        if (search) {
            const escapedSearch = search.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
            query.$or = [
                { sku: { $regex: escapedSearch, $options: 'i' } },
                { $expr: { $regexMatch: { input: { $toString: "$lotNumber" }, regex: escapedSearch, options: 'i' } } },
                { description: { $regex: search, $options: 'i' } },
                { shortDescription: { $regex: search, $options: 'i' } },
                { name: { $regex: search, $options: 'i' } }
            ];
        }
        const products = await this.productModel
            .find(query)
            .skip(skip)
            .limit(limit)
            .exec();
        const total = await this.productModel.countDocuments().exec();
        return {
            data: products,
            total,
            page,
            limit,
            totalPages: Math.ceil(total / limit),
        };
    }
    async findAllProductsPages(paginationQuery) {
        var { page = 1, limit = 27, search, category, fromprice = 0, toprice = 99999999, itemstatus = '', material = '' } = paginationQuery;
        limit = 27;
        const skip = (page - 1) * limit;
        if (fromprice == null) {
            fromprice = 0;
        }
        if (toprice == null) {
            toprice = 9999999;
        }
        if (!fromprice) {
            fromprice = 0;
        }
        if (!toprice) {
            toprice = 9999999;
        }
        const cats = await this.categoryModel.findOne({ name: category }).exec();
        if (!cats) {
            const query = {};
            var escapedSearch = '';
            if (search) {
                escapedSearch = search.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
            }
            query.$and = [
                {
                    $or: [
                        { sku: { $regex: escapedSearch, $options: 'i' } },
                        { description: { $regex: escapedSearch, $options: 'i' } },
                        { shortDescription: { $regex: escapedSearch, $options: 'i' } },
                        { name: { $regex: escapedSearch, $options: 'i' } },
                        ...(isNaN(escapedSearch) ? [] : [{ lotNumber: { $eq: escapedSearch } }])
                    ]
                },
            ];
            const priceFilter = {};
            if (fromprice !== undefined) {
                priceFilter.$gte = fromprice;
            }
            if (toprice !== undefined) {
                priceFilter.$lte = toprice;
            }
            if (Object.keys(priceFilter).length > 0) {
                query.$and.push({ startPrice: priceFilter });
            }
            const materialFilter = {};
            if (material != null && material !== '') {
                materialFilter.material = {
                    $regex: `^${material}$`,
                    $options: 'i'
                };
                query.$and.push(materialFilter);
            }
            const statusfilter = {};
            if (itemstatus != null && itemstatus !== '') {
                const today = new Date();
                today.setHours(0, 0, 0, 0);
                if (itemstatus == 'ongoing') {
                    query.$and.push({ auctionStartDate: { $gte: today.toISOString().split('T')[0] }, auctionEndDate: { $lte: today.toISOString().split('T')[0] } });
                }
                if (itemstatus == 'upcoming') {
                    query.$and.push({ auctionStartDate: { $gte: today.toISOString().split('T')[0] } });
                }
                if (itemstatus == 'ended') {
                    query.$and.push({ auctionEndDate: { $lt: today.toISOString().split('T')[0] } });
                }
            }
            const products = await this.productModel
                .find(query)
                .skip(skip)
                .sort({ lotNumber: 1 })
                .limit(limit).populate('category')
                .exec();
            const total = await this.productModel.countDocuments(query).exec();
            return {
                data: products,
                total,
                page,
                limit,
                totalPages: Math.ceil(total / limit),
            };
        }
        else {
            const query = {};
            var escapedSearch = '';
            if (search) {
                escapedSearch = search.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
            }
            const categoryId = cats._id;
            const categories = await this.categoryModel
                .find({ $or: [{ _id: categoryId }, { parent: categoryId }] })
                .exec();
            const categoryIds = categories.map(category => category._id);
            query.$and = [
                {
                    $or: [
                        { sku: { $regex: escapedSearch, $options: 'i' } },
                        { description: { $regex: escapedSearch, $options: 'i' } },
                        { shortDescription: { $regex: escapedSearch, $options: 'i' } },
                        { name: { $regex: escapedSearch, $options: 'i' } }
                    ]
                },
                { category: { $in: categoryIds } }
            ];
            const priceFilter = {};
            if (fromprice !== undefined) {
                priceFilter.$gte = fromprice;
            }
            if (toprice !== undefined) {
                priceFilter.$lte = toprice;
            }
            if (Object.keys(priceFilter).length > 0) {
                query.$and.push({ startPrice: priceFilter });
            }
            const materialFilter = {};
            if (material != null && material !== '') {
                materialFilter.material = {
                    $regex: `^${material}$`,
                    $options: 'i'
                };
                query.$and.push(materialFilter);
            }
            const statusfilter = {};
            if (itemstatus != null && itemstatus !== '') {
                const today = new Date();
                today.setHours(0, 0, 0, 0);
                if (itemstatus == 'ongoing') {
                    query.$and.push({ auctionStartDate: { $gte: today }, auctionEndDate: { $lte: today } });
                }
                if (itemstatus == 'upcoming') {
                    query.$and.push({ auctionStartDate: { $lt: today } });
                }
                if (itemstatus == 'ended') {
                    query.$and.push({ auctionStartDate: { $gt: today } });
                }
            }
            const products = await this.productModel
                .find(query)
                .skip(skip)
                .limit(limit).populate('category')
                .exec();
            const total = await this.productModel.countDocuments(query).exec();
            return {
                data: products,
                total,
                page,
                limit,
                totalPages: Math.ceil(total / limit),
            };
        }
    }
    async deleteImage(body) {
        if (!body.image) {
            return {
                statuscode: 'failed',
                message: 'Missing Image',
            };
        }
        await this.productModel.findByIdAndUpdate(body.id, { $pull: { images: body.image } }, { new: true }).exec();
        return {
            statuscode: 'success',
            message: 'Image Removed from Product',
        };
    }
    async myBidHistory(body, id) {
        const result = await this.bidModel.aggregate([
            {
                $match: { user: id },
            },
            {
                $group: {
                    _id: '$product',
                },
            },
            {
                $addFields: {
                    productId: { $toObjectId: '$_id' },
                },
            },
            {
                $lookup: {
                    from: 'products',
                    localField: 'productId',
                    foreignField: '_id',
                    as: 'productDetails',
                },
            },
            {
                $unwind: '$productDetails',
            },
            {
                $lookup: {
                    from: 'bids',
                    localField: '_id',
                    foreignField: 'product',
                    as: 'allBids',
                },
            },
            {
                $addFields: {
                    topBid: {
                        $arrayElemAt: [
                            {
                                $sortArray: { input: '$allBids', sortBy: { bidAmount: -1 } },
                            },
                            0,
                        ],
                    },
                },
            },
            {
                $project: {
                    _id: 0,
                    product: '$productDetails',
                    maxBid: '$topBid.bidAmount',
                    topBidUser: '$topBid.user',
                },
            },
        ]);
        return {
            statuscode: 'success',
            data: result,
            id: id
        };
    }
    async myDashboard(body, id) {
        const count = await this.bidModel.aggregate([
            {
                $match: { user: id },
            },
            {
                $group: {
                    _id: '$product',
                },
            },
            {
                $count: 'productCount',
            },
        ]);
        const wincount = await this.bidModel.aggregate([
            {
                $match: { user: id },
            },
            {
                $group: {
                    _id: '$product',
                },
            },
            {
                $addFields: {
                    productId: { $toObjectId: '$_id' },
                },
            },
            {
                $lookup: {
                    from: 'products',
                    localField: 'productId',
                    foreignField: '_id',
                    as: 'productDetails',
                },
            },
            {
                $match: {
                    'productDetails.finaluser': id,
                },
            },
            {
                $count: 'productCount',
            },
        ]);
        const allbidcount = await this.bidModel.aggregate([
            {
                $group: {
                    _id: '$product',
                },
            },
            {
                $addFields: {
                    productId: { $toObjectId: '$_id' },
                },
            },
            {
                $lookup: {
                    from: 'products',
                    localField: 'productId',
                    foreignField: '_id',
                    as: 'productDetails',
                },
            },
            {
                $unwind: '$productDetails',
            },
            {
                $lookup: {
                    from: 'bids',
                    localField: '_id',
                    foreignField: 'product',
                    as: 'allBids',
                },
            },
            {
                $addFields: {
                    topBid: {
                        $arrayElemAt: [
                            {
                                $sortArray: { input: '$allBids', sortBy: { bidAmount: -1 } },
                            },
                            0,
                        ],
                    },
                },
            },
            {
                $project: {
                    _id: 0,
                    product: '$productDetails',
                    maxBid: '$topBid.bidAmount',
                    topBidUser: '$topBid.user',
                },
            },
        ]);
        return {
            statuscode: 'success',
            totalbids: count.length > 0 ? count[0].productCount : 0,
            winningbids: wincount.length > 0 ? wincount[0].productCount : 0,
            allbids: allbidcount.length,
        };
    }
    async getAdjacentProductsBySku(body) {
        var sku = body.sku;
        const currentProduct = await this.productModel.findOne({ sku }).exec();
        const today = new Date();
        today.setHours(0, 0, 0, 0);
        if (!currentProduct) {
            throw new common_1.NotFoundException(`Product with SKU "${sku}" not found`);
        }
        const lotNumber = currentProduct.lotNumber;
        const previousProduct = await this.productModel
            .findOne({ lotNumber: { $lt: lotNumber }, auctionEndDate: { $gt: today } })
            .sort({ lotNumber: -1 })
            .exec();
        const nextProduct = await this.productModel
            .findOne({ lotNumber: { $gt: lotNumber }, auctionEndDate: { $gt: today } })
            .sort({ lotNumber: 1 })
            .exec();
        return {
            previous: previousProduct || null,
            current: currentProduct,
            next: nextProduct || null,
        };
    }
    async allBidHistory(body, id) {
        const newresult = await this.bidModel.aggregate([
            {
                $addFields: {
                    productObjectId: { $toObjectId: "$product" }
                }
            },
            {
                $group: {
                    _id: "$productObjectId",
                    highestBidAmount: { $max: "$bidAmount" },
                    highestBidDetails: { $first: "$$ROOT" }
                }
            },
            {
                $lookup: {
                    from: "products",
                    localField: "_id",
                    foreignField: "_id",
                    as: "productDetails"
                }
            },
            {
                $unwind: "$productDetails"
            }
        ]);
        return {
            statuscode: 'success',
            data: newresult,
            id: id
        };
    }
    async requestVideo(body, user) {
        const productId = body.productid;
        const existingVideo = await this.videoModel.findOne({ user: user, product: productId });
        if (existingVideo) {
            return {
                statuscode: 'failed',
                msg: 'You have already requested video for this product. Please contact administrator if you have not recieved any updates.',
            };
        }
        const newVideo = new this.videoModel({
            user: user,
            product: productId,
        });
        await newVideo.save();
        return {
            statuscode: 'success',
            msg: 'Request for video for this product has been sent to Administrator.',
        };
    }
    async myrequestedVideo(body, user) {
        const existingVideos = await this.videoModel.find({ user: user }).populate('product');
        return {
            statuscode: 'success',
            data: existingVideos,
        };
    }
    async allrequestedVideo(body, user) {
        const existingVideos = await this.videoModel.find().populate('product').populate('user');
        return {
            statuscode: 'success',
            data: existingVideos,
        };
    }
    async alertFloorWinner(productId) {
        const productdata = await this.productModel.findById(productId).exec();
        if (productdata) {
            if (productdata.finaluser == null) {
                var plain = "Hello,  Congratulations! Bid for the item at the Travancore Cochin Heritage Auction has ended!. Item Details: " + productdata.name + ", Winning Bid: " + productdata.finalamount + ",Lot Number: " + productdata.lotNumber + ". Regards, Travancore Heritage Auctions .";
                var content = "<p>Hello ,</p><br> <p>Congratulations! Bid for the item at the Travancore Cochin Heritage Auction has ended!</p><br><br> <p>Item Details: " + productdata.name + ",</p><br> <p>Winning Bid: " + productdata.finalamount + ",</p><br> <p>Lot Number: " + productdata.lotNumber + "</p><br> <p>. Regards, Travancore Heritage Auctions .</p>";
                var subject = "Bidding Closed - Travancore Heritage Auction";
            }
            else {
                const userdata = await this.userModel.findById(productdata.finaluser).exec();
                if (userdata) {
                    var plain = "Hello " + userdata.firstname + ' ' + userdata.lastname + ", Congratulations! We are pleased to inform you that you have won the bid for the item at the Travancore Cochin Heritage Auction! Your successful bid has secured this remarkable piece. Thank you for your participation and enthusiasm. Item Details: " + productdata.name + ", Winning Bid: " + productdata.finalamount + ",Lot Number: " + productdata.lotNumber + ". Regards, Travancore Heritage Auctions .";
                    var content = "<p>Hello " + userdata.firstname + ' ' + userdata.lastname + ",</p><br> <p>Congratulations! We are pleased to inform you that you have won the bid for the item at the Travancore Cochin Heritage Auction! Your successful bid has secured this remarkable piece. Thank you for your participation and enthusiasm.</p><br><br> <p>Item Details: " + productdata.name + ",</p><br> <p>Winning Bid: " + productdata.finalamount + ",</p><br> <p>Lot Number: " + productdata.lotNumber + "</p><br> <p>. Regards, Travancore Heritage Auctions .</p>";
                    var subject = "Bidding Won - Travancore Heritage Auction";
                    this.sendEmail("info@travancoreheritageauction.com", userdata.firstname + ' ' + userdata.lastname, plain, content, subject);
                }
            }
        }
    }
    async getCurrentAndNextLot() {
        const today = new Date();
        today.setHours(0, 0, 0, 0);
        var currentLot = await this.productModel
            .findOne({
            $and: [
                {
                    $or: [
                        { auctionStatus: 0 },
                        { auctionStatus: { $exists: false } },
                    ],
                },
                { lotNumber: { $exists: true, $ne: null } },
                { lotNumber: { $gt: 0 } },
                { auctionEndDate: { $gt: today } },
            ],
        })
            .sort({ lotNumber: 1 })
            .exec();
        if (currentLot && currentLot.finaluser) {
            var currentuserdata = await this.userModel.findById(currentLot.finaluser).exec();
        }
        const nextLot = currentLot ? await this.productModel
            .findOne({
            $and: [
                {
                    $or: [
                        { auctionStatus: 0 },
                        { auctionStatus: { $exists: false } },
                    ],
                },
                { lotNumber: { $exists: true, $ne: null } },
                { lotNumber: { $gt: currentLot.lotNumber } },
                { auctionEndDate: { $gt: today } },
            ],
        })
            .sort({ lotNumber: 1 })
            .exec() : null;
        if (nextLot && nextLot.finaluser) {
            var nextuserdata = await this.userModel.findById(nextLot.finaluser).exec();
        }
        var previousLot = currentLot ? await this.productModel
            .findOne({
            $and: [
                { lotNumber: { $exists: true, $ne: null } },
                { lotNumber: { $lt: currentLot.lotNumber } },
                { auctionEndDate: { $gt: today } },
            ],
        })
            .sort({ lotNumber: -1 })
            .exec() : null;
        if (previousLot && previousLot.finaluser) {
            var previoususerdata = await this.userModel.findById(previousLot.finaluser).exec();
        }
        if (!previousLot) {
            var previousLot = await this.productModel
                .findOne()
                .sort({ lotNumber: -1 })
                .exec();
        }
        var lastbid = await this.bidModel.find({ product: previousLot?._id.toString() }).exec();
        return {
            current: currentLot,
            currentuser: currentuserdata,
            next: nextLot,
            nextuser: nextuserdata,
            previous: previousLot,
            previoususer: previoususerdata,
            previousbid: lastbid,
        };
    }
    async gethomeCurrentAndNextLot() {
        var currentLot = await this.productModel
            .findOne({
            $and: [
                {
                    $or: [
                        { auctionStatus: 0 },
                        { auctionStatus: { $exists: false } },
                    ],
                },
                { lotNumber: { $exists: true, $ne: null } },
                { lotNumber: { $gt: 0 } },
            ],
        })
            .sort({ lotNumber: 1 })
            .exec();
        if (currentLot && currentLot.finaluser) {
            var currentuserdata = await this.userModel.findById(currentLot.finaluser).exec();
        }
        const nextLot = currentLot ? await this.productModel
            .findOne({
            $and: [
                {
                    $or: [
                        { auctionStatus: 0 },
                        { auctionStatus: { $exists: false } },
                    ],
                },
                { lotNumber: { $exists: true, $ne: null } },
                { lotNumber: { $gt: currentLot.lotNumber } },
            ],
        })
            .sort({ lotNumber: 1 })
            .exec() : null;
        if (nextLot && nextLot.finaluser) {
            var nextuserdata = await this.userModel.findById(nextLot.finaluser).exec();
        }
        const previousLot = currentLot ? await this.productModel
            .findOne({
            $and: [
                { lotNumber: { $exists: true, $ne: null } },
                { lotNumber: { $lt: currentLot.lotNumber } },
            ],
        })
            .sort({ lotNumber: -1 })
            .exec() : null;
        if (previousLot && previousLot.finaluser) {
            var previoususerdata = await this.userModel.findById(previousLot.finaluser).exec();
        }
        return {
            current: currentLot,
            currentuser: currentuserdata,
            next: nextLot,
            nextuser: nextuserdata,
            previous: previousLot,
            previoususer: previoususerdata
        };
    }
    async generateResult(body, user) {
        var productId = body.productid;
        const product = await this.productModel.findById(body.productid).exec();
        const currentTime = new Date();
        if (product.lotstart == '1') {
            const extendAuctionForSeconds = product.extendAuctionForSeconds || 20;
            const lastBid = await this.bidModel.find({ product: productId })
                .sort({ createdAt: -1 })
                .limit(1)
                .exec();
            if (lastBid.length > 0) {
                const lastBidTime = new Date(lastBid[0].createdAt);
                const timeDifference = (currentTime.getTime() - lastBidTime.getTime()) / 1000;
                if (timeDifference > extendAuctionForSeconds) {
                    if (lastBid[0].bidAmount < product.reservePrice) {
                        await this.productModel.findByIdAndUpdate(productId, { auctionStatus: '-1' });
                        await this.alertFloorWinner(productId);
                        const newResult = new this.resultModel({
                            product: productId,
                            auctionStatus: '-1'
                        });
                        await newResult.save();
                        return {
                            statuscode: 'failure',
                            message: 'Auction has ended without being sold',
                        };
                    }
                    else {
                        var highestReserve = await this.reserveModel
                            .findOne({ product: productId })
                            .sort({ reserveAmount: -1 })
                            .select('user reserveAmount')
                            .exec();
                        if (highestReserve) {
                            if (lastBid[0].bidAmount <= highestReserve.reserveAmount && highestReserve.user == lastBid[0].user) {
                                await this.productModel.findByIdAndUpdate(productId, { finaluser: lastBid[0].user });
                                await this.productModel.findByIdAndUpdate(productId, { finalamount: lastBid[0].bidAmount });
                                await this.productModel.findByIdAndUpdate(productId, { auctionStatus: '1' });
                            }
                            if (lastBid[0].bidAmount <= highestReserve.reserveAmount && highestReserve.user != lastBid[0].user) {
                                const setting = await this.settingModel.findOne({
                                    fromamount: { $lte: lastBid[0].bidAmount },
                                    toamount: { $gte: lastBid[0].bidAmount },
                                });
                                const bidIncrement = setting ? setting.bidincrement : 0;
                                if (lastBid.length > 0) {
                                    var nextBidAmount = lastBid[0].bidAmount + bidIncrement;
                                }
                                else {
                                    var nextBidAmount = lastBid[0].bidAmount;
                                }
                                await this.productModel.findByIdAndUpdate(productId, { finaluser: highestReserve.user });
                                await this.productModel.findByIdAndUpdate(productId, { finalamount: nextBidAmount });
                                await this.productModel.findByIdAndUpdate(productId, { auctionStatus: '1' });
                            }
                            if (lastBid[0].bidAmount > highestReserve.reserveAmount) {
                                await this.productModel.findByIdAndUpdate(productId, { finaluser: lastBid[0].user });
                                await this.productModel.findByIdAndUpdate(productId, { finalamount: lastBid[0].bidAmount });
                                await this.productModel.findByIdAndUpdate(productId, { auctionStatus: '1' });
                            }
                        }
                        else {
                            console.log("got here");
                            await this.productModel.findByIdAndUpdate(productId, { finaluser: lastBid[0].user });
                            await this.productModel.findByIdAndUpdate(productId, { finalamount: lastBid[0].bidAmount });
                            await this.productModel.findByIdAndUpdate(productId, { auctionStatus: '1' });
                        }
                        const newResult = new this.resultModel({
                            product: productId,
                            auctionStatus: '1'
                        });
                        await newResult.save();
                        return {
                            statuscode: 'success',
                            message: `Bidding has ended for this product and result declared`,
                        };
                    }
                }
                else {
                    return {
                        statuscode: 'failure',
                        message: 'Bid Result awaiting as bid extension time is not over',
                    };
                }
            }
            else {
                const lastBidTime = new Date(product.productDate);
                const timeDifference = (currentTime.getTime() - lastBidTime.getTime()) / 1000;
                if (timeDifference > extendAuctionForSeconds) {
                    await this.productModel.findByIdAndUpdate(productId, { auctionStatus: '-1' });
                    await this.alertFloorWinner(productId);
                    const newResult = new this.resultModel({
                        product: productId,
                        auctionStatus: '-1'
                    });
                    await newResult.save();
                    return {
                        statuscode: 'failure',
                        message: 'Auction has ended without being sold',
                    };
                }
                else {
                    return {
                        statuscode: 'failure',
                        message: 'Bid Result awaiting as bid extension time is not over',
                    };
                }
            }
        }
    }
    async getActiveLot() {
        var currentLot = await this.productModel.findOne({
            $and: [
                {
                    $or: [
                        { auctionStatus: 0 },
                        { auctionStatus: { $exists: false } },
                    ],
                },
                { lotNumber: { $exists: true, $ne: null } },
                { lotstart: 1 },
            ],
        })
            .sort({ lotNumber: 1 })
            .exec();
        return {
            current: currentLot,
        };
    }
    async getNextLiveLot() {
        const today = new Date();
        today.setHours(0, 0, 0, 0);
        var currentLot = await this.productModel.findOne({
            $and: [
                {
                    $or: [
                        { auctionStatus: 0 },
                        { auctionStatus: { $exists: false } },
                    ],
                },
                { lotNumber: { $exists: true, $ne: null, $gt: 0 } },
                { lotstart: 1 },
                { auctionEndDate: { $gt: today } },
            ],
        })
            .sort({ lotNumber: 1 })
            .exec();
        if (currentLot) {
            return {
                current: currentLot,
            };
        }
        else {
            var upcomingLot = await this.productModel.findOne({
                $and: [
                    {
                        $or: [
                            { auctionStatus: 0 },
                            { auctionStatus: { $exists: false } },
                        ],
                    },
                    { lotNumber: { $exists: true, $ne: null, $gt: 0 } },
                    { lotstart: 0 },
                    { auctionEndDate: { $gt: today } },
                ],
            })
                .sort({ lotNumber: 1 })
                .exec();
            return {
                current: upcomingLot,
            };
        }
    }
    async lastResult() {
        const result = await this.resultModel
            .findOne()
            .sort({ createdAt: -1 })
            .populate('product')
            .exec();
        return {
            result: result,
        };
    }
    async getCart(userId) {
        return this.cartModel.findOne({ user: new mongoose_2.Types.ObjectId(userId) }).populate('items.productId').exec();
    }
    async addToCart(userId, productId, quantity) {
        if (!productId || !quantity) {
            throw new Error('Product ID and quantity are required');
        }
        let cart = await this.cartModel.findOne({ user: new mongoose_2.Types.ObjectId(userId) });
        if (cart) {
            if (!cart.items) {
                cart.items = [];
            }
            const itemIndex = cart.items.findIndex((item) => item.productId.toString() === productId);
            if (itemIndex > -1) {
                return {
                    statuscode: 'failure',
                    message: 'You have already added this product in to the cart.',
                    cart: cart
                };
            }
            else {
                cart.items.push({ productId: new mongoose_2.Types.ObjectId(productId), quantity });
                await cart.save();
            }
            return {
                statuscode: 'success',
                message: 'Product added in to the cart.',
                cart: await this.cartModel.findOne({ user: new mongoose_2.Types.ObjectId(userId) })
            };
        }
        const newCart = new this.cartModel({
            user: new mongoose_2.Types.ObjectId(userId),
            items: [{ productId: new mongoose_2.Types.ObjectId(productId), quantity }],
        });
        await newCart.save();
        return {
            statuscode: 'success',
            message: 'Product added in to the cart.',
            cart: await this.cartModel.findOne({ user: new mongoose_2.Types.ObjectId(userId) })
        };
    }
    async removeFromCart(userId, productId) {
        const cart = await this.cartModel.findOne({ user: new mongoose_2.Types.ObjectId(userId) });
        if (cart) {
            cart.items = cart.items.filter((item) => item.productId.toString() !== productId);
            await cart.save();
            return {
                statuscode: 'success',
                message: 'Product removed from cart.',
                cart: await this.cartModel.findOne({ user: new mongoose_2.Types.ObjectId(userId) })
            };
        }
    }
    async clearCart(userId) {
        await this.cartModel.findOneAndUpdate({ user: new mongoose_2.Types.ObjectId(userId) }, { items: [] });
        return {
            statuscode: 'success',
            message: 'Cart Cleared.',
            cart: await this.cartModel.findOne({ user: new mongoose_2.Types.ObjectId(userId) })
        };
    }
    async isProductInCart(userId, productId) {
        const cart = await this.cartModel.findOne({ user: new mongoose_2.Types.ObjectId(userId) });
        if (!cart) {
            return { exists: false };
        }
        const productExists = cart.items.some((item) => item.productId.toString() === productId);
        return { exists: productExists };
    }
    async changeManulStatus(body) {
        const objectId = new mongoose_2.Types.ObjectId(body.id);
        const filter = { _id: objectId };
        const update = { $set: { auctionStatus: body.val } };
        const result = await this.productModel.updateOne(filter, update);
        return result;
    }
};
exports.ProductService = ProductService;
exports.ProductService = ProductService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)('Category')),
    __param(1, (0, mongoose_1.InjectModel)(product_schema_1.Product.name)),
    __param(2, (0, mongoose_1.InjectModel)(user_schema_1.User.name)),
    __param(3, (0, mongoose_1.InjectModel)(bid_schema_1.Bid.name)),
    __param(4, (0, mongoose_1.InjectModel)(cart_schema_1.Cart.name)),
    __param(5, (0, mongoose_1.InjectModel)(video_schema_1.Video.name)),
    __param(6, (0, mongoose_1.InjectModel)(result_schema_1.Result.name)),
    __param(7, (0, mongoose_1.InjectModel)(reserve_schema_1.Reserve.name)),
    __param(8, (0, mongoose_1.InjectModel)(setting_schema_1.Setting.name)),
    __metadata("design:paramtypes", [mongoose_2.Model,
        mongoose_2.Model,
        mongoose_2.Model,
        mongoose_2.Model,
        mongoose_2.Model,
        mongoose_2.Model,
        mongoose_2.Model,
        mongoose_2.Model,
        mongoose_2.Model,
        email_service_1.EmailService])
], ProductService);
//# sourceMappingURL=product.service.js.map