import { Model } from 'mongoose';
import { Category } from '../categories/schemas/category.schema';
import { Product } from './schemas/product.schema';
import { Bid } from './schemas/bid.schema';
import { Cart } from './schemas/cart.schema';
import { Video } from './schemas/video.schema';
import { Result } from './schemas/result.schema';
import { Reserve } from './schemas/reserve.schema';
import { Setting } from '../settings/setting.schema';
import { User } from '../users/schemas/user.schema';
import { PaginationQueryDto } from './dto/pagination-query.dto';
import { EmailService } from '../email/email.service';
export declare class ProductService {
    private readonly categoryModel;
    private productModel;
    private userModel;
    private bidModel;
    private cartModel;
    private videoModel;
    private resultModel;
    private reserveModel;
    private settingModel;
    private readonly emailService;
    constructor(categoryModel: Model<Category>, productModel: Model<Product>, userModel: Model<User>, bidModel: Model<Bid>, cartModel: Model<Cart>, videoModel: Model<Video>, resultModel: Model<Result>, reserveModel: Model<Reserve>, settingModel: Model<Setting>, emailService: EmailService);
    create(productDto: Partial<Product>): Promise<Product>;
    findAll(): Promise<Product[]>;
    findOne(id: string): Promise<Product>;
    update(id: string, productDto: any, newImages: string[]): Promise<Product>;
    updateWithImages(id: string, productDto: any, newImages: string[]): Promise<Product>;
    remove(id: string): Promise<void>;
    getCategoriesWithProductCount(): Promise<any[]>;
    getMainCategoriesWithProductCount(): Promise<any[]>;
    getProductsByCategory(name: any): Promise<any[]>;
    findBySKU(sku: any): Promise<Product>;
    getProductBySKULanding(sku: any): Promise<any>;
    findByLots(paginationQuery: PaginationQueryDto): Promise<any>;
    findByPastLots(paginationQuery: PaginationQueryDto): Promise<any>;
    getProductByStore(paginationQuery: PaginationQueryDto): Promise<any>;
    bidHistory(body: any): Promise<any>;
    bidReserve(body: any, id: string): Promise<any>;
    newBid(body: any, user: any): Promise<any>;
    alertLastBidder(productId: any): Promise<any>;
    alertCurrentBidder(productId: any): Promise<any>;
    sendEmail(to: any, name: any, plain: any, content: any, subject: any): Promise<any>;
    newReserve(body: any, user: any): Promise<any>;
    addBanner(body: any): Promise<any>;
    removeBanner(body: any): Promise<any>;
    homeBanners(body: any): Promise<any>;
    upcomingAuctions(body: any): Promise<any>;
    liveAuctions(body: any): Promise<any>;
    pastAuctions(body: any): Promise<any>;
    switchLotAuction(body: any): Promise<any>;
    bulkUpdate(body: any): Promise<any>;
    findAllPages(paginationQuery: PaginationQueryDto): Promise<{
        data: (import("mongoose").Document<unknown, {}, Product> & Product & Required<{
            _id: unknown;
        }> & {
            __v: number;
        })[];
        total: number;
        page: number;
        limit: number;
        totalPages: number;
    }>;
    findAllProductsPages(paginationQuery: PaginationQueryDto): Promise<{
        data: (import("mongoose").Document<unknown, {}, Product> & Product & Required<{
            _id: unknown;
        }> & {
            __v: number;
        })[];
        total: number;
        page: number;
        limit: number;
        totalPages: number;
    }>;
    deleteImage(body: any): Promise<any>;
    myBidHistory(body: any, id: string): Promise<any>;
    myDashboard(body: any, id: string): Promise<any>;
    getAdjacentProductsBySku(body: any): Promise<{
        previous: any;
        current: any;
        next: any;
    }>;
    allBidHistory(body: any, id: string): Promise<any>;
    requestVideo(body: any, user: any): Promise<any>;
    myrequestedVideo(body: any, user: any): Promise<any>;
    allrequestedVideo(body: any, user: any): Promise<any>;
    alertFloorWinner(productId: any): Promise<any>;
    getCurrentAndNextLot(): Promise<any>;
    gethomeCurrentAndNextLot(): Promise<any>;
    generateResult(body: any, user: any): Promise<any>;
    getActiveLot(): Promise<any>;
    getNextLiveLot(): Promise<any>;
    lastResult(): Promise<any>;
    getCart(userId: string): Promise<Cart | null>;
    addToCart(userId: string, productId: string, quantity: number): Promise<any>;
    removeFromCart(userId: string, productId: string): Promise<any>;
    clearCart(userId: string): Promise<any>;
    isProductInCart(userId: string, productId: string): Promise<{
        exists: boolean;
    }>;
    changeManulStatus(body: any): Promise<any>;
}
