"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IsGreaterThan = IsGreaterThan;
const class_validator_1 = require("class-validator");
function IsGreaterThan(property, validationOptions) {
    return function (object, propertyName) {
        (0, class_validator_1.registerDecorator)({
            name: 'isGreaterThan',
            target: object.constructor,
            propertyName,
            options: validationOptions,
            constraints: [property],
            validator: {
                validate(value, args) {
                    const relatedValue = args.object[args.constraints[0]];
                    return typeof value === 'number' && typeof relatedValue === 'number' && value > relatedValue;
                },
            },
        });
    };
}
//# sourceMappingURL=is-greater-than.validator.js.map