"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const mongoose_2 = require("mongoose");
const setting_schema_1 = require("./setting.schema");
const banner_schema_1 = require("./banner.schema");
let SettingsService = class SettingsService {
    constructor(settingsModel, bannerModel) {
        this.settingsModel = settingsModel;
        this.bannerModel = bannerModel;
    }
    async createIncrement(settingsDto) {
        const newSetting = new this.settingsModel(settingsDto);
        return newSetting.save();
    }
    async findAll() {
        return this.settingsModel.find().sort({ fromamount: 1 }).exec();
    }
    async delete(id) {
        return this.settingsModel.findByIdAndDelete(id).exec();
    }
    async addBanner(body, user, images) {
        console.log(images);
        const newBanner = new this.bannerModel({
            images: images[0],
        });
        await newBanner.save();
        return {
            statuscode: 'success',
            message: 'Banner added.',
        };
    }
    async getBanners() {
        return this.bannerModel.find().exec();
    }
    async removeBanner(body) {
        const result = await this.bannerModel.findByIdAndDelete(body.id).exec();
        if (!result) {
            throw new common_1.NotFoundException(`Banner with id ${body.id} not found`);
        }
        else {
            return {
                statuscode: 'success',
                message: 'Banner removed',
            };
        }
    }
};
exports.SettingsService = SettingsService;
exports.SettingsService = SettingsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(setting_schema_1.Setting.name)),
    __param(1, (0, mongoose_1.InjectModel)(banner_schema_1.Banner.name)),
    __metadata("design:paramtypes", [mongoose_2.Model,
        mongoose_2.Model])
], SettingsService);
//# sourceMappingURL=settings.service.js.map