import { UsersService } from './users.service';
import { CreateUserDto } from './dto/create-user.dto';
import { LoginUserDto } from './dto/login-user.dto';
export declare class UsersController {
    private readonly usersService;
    constructor(usersService: UsersService);
    createUser(createUserDto: any): Promise<import("./schemas/user.schema").User>;
    getDashboard(req: any): {
        status: string;
        message: string;
        user: any;
    };
    registerUser(createUserDto: CreateUserDto): Promise<{
        status: string;
        message: string;
    }>;
    resendOTP(body: any): Promise<{
        status: string;
        message: string;
    }>;
    getAllUsers(): Promise<import("./schemas/user.schema").User[]>;
    getInactiveUsers(): Promise<import("./schemas/user.schema").User[]>;
    updateInactiveUsers(id: string): Promise<{
        message: string;
        user?: undefined;
    } | {
        message: string;
        user: any;
    }>;
    getUserById(id: string): Promise<import("./schemas/user.schema").User>;
    updateUser(id: string, updateUserDto: any, files: Express.Multer.File[]): Promise<import("./schemas/user.schema").User>;
    deleteDocs(body: any, req: any): Promise<any>;
    deleteUser(id: string): Promise<import("./schemas/user.schema").User>;
    login(loginUserDto: LoginUserDto): Promise<{
        status: string;
        message: string;
        data: string;
    } | {
        status: string;
        message: string;
        data: {
            userId: unknown;
            email: string;
            role: string;
            type: string;
        };
    }>;
    getProfile(req: any): Promise<{
        status: string;
        message: string;
        userdata: import("./schemas/user.schema").User;
    }>;
    updateBidAmount(body: any): Promise<any>;
    changePassword(body: any): Promise<any>;
    resetPassword(body: any): Promise<any>;
    send(): Promise<any>;
    createData(body: any, req: any): Promise<any>;
    getData(body: any, req: any): Promise<any>;
    delete(body: any, req: any): Promise<any>;
    getUserData(body: any, req: any): Promise<any>;
    getTotalUsersCount(): Promise<{
        count: number;
    }>;
}
