import { Model } from 'mongoose';
import { User } from './schemas/user.schema';
import { Previousdata } from './schemas/previousdata.schema';
import { LoginUserDto } from './dto/login-user.dto';
import { EmailService } from '../email/email.service';
export declare class UsersService {
    private userModel;
    private previousdataModel;
    private readonly emailService;
    constructor(userModel: Model<User>, previousdataModel: Model<Previousdata>, emailService: EmailService);
    createUser(createUserDto: any): Promise<User>;
    getAllUsers(): Promise<User[]>;
    getUserById(id: string): Promise<User>;
    updateUser(id: string, updateUserDto: any, newImages: string[]): Promise<User>;
    deleteDocs(body: any): Promise<any>;
    deleteUser(id: string): Promise<User>;
    private sendWelcomeEmail;
    findByEmail(email: string): Promise<User | null>;
    comparePasswords(plainPassword: string, hashedPassword: string): Promise<boolean>;
    login(loginUserDto: LoginUserDto): Promise<{
        status: string;
        message: string;
        data: string;
    } | {
        status: string;
        message: string;
        data: {
            userId: unknown;
            email: string;
            role: string;
            type: string;
        };
    }>;
    getInactiveUsers(): Promise<User[]>;
    approveUser(id: string): Promise<any>;
    approveOTP(id: string): Promise<User>;
    resendOTP(body: any): Promise<any>;
    resetPassword(body: any): Promise<any>;
    updateBidAmount(body: any): Promise<any>;
    changePassword(body: any): Promise<any>;
    sendEmail(to: any, name: any, plain: any, content: any, subject: any): Promise<any>;
    send(): Promise<any>;
    createData(body: any, user: any): Promise<any>;
    getData(user: any): Promise<any>;
    deleteData(body: any, user: any): Promise<any>;
    getUserData(body: any): Promise<any>;
    getTotalUsersCount(): Promise<any>;
}
