"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const mongoose_2 = require("mongoose");
const user_schema_1 = require("./schemas/user.schema");
const previousdata_schema_1 = require("./schemas/previousdata.schema");
const bcrypt = require("bcrypt");
const email_service_1 = require("../email/email.service");
const axios = require('axios');
let UsersService = class UsersService {
    constructor(userModel, previousdataModel, emailService) {
        this.userModel = userModel;
        this.previousdataModel = previousdataModel;
        this.emailService = emailService;
    }
    async createUser(createUserDto) {
        const { firstname, lastname, email, phone, maxBidAmount, usertype, userrole, otp, otpstatus, password } = createUserDto;
        const existingUser = await this.userModel.findOne({ email });
        if (existingUser) {
            throw new common_1.ConflictException('Email already exists');
        }
        const digits = '0123456789';
        let newotp = '';
        for (let i = 0; i < 6; i++) {
            newotp += digits[Math.floor(Math.random() * digits.length)];
        }
        const hashedPassword = await bcrypt.hash(password, 10);
        const newregno = await this.userModel.countDocuments() + 1;
        const newUser = new this.userModel({
            regno: newregno,
            firstname,
            lastname,
            email,
            phone,
            maxBidAmount,
            userrole,
            usertype,
            otp: newotp,
            otpstatus,
            password: hashedPassword,
        });
        const savedUser = await newUser.save();
        const wresponse = await axios.post('https://graph.facebook.com/v23.0/709680682221149/messages', {
            messaging_product: 'whatsapp',
            to: phone,
            type: 'template',
            template: {
                name: 'user_registration',
                language: {
                    code: 'en',
                },
                components: [
                    {
                        type: 'body',
                        parameters: [
                            {
                                type: 'text',
                                parameter_name: 'name',
                                text: savedUser.firstname + ' ' + savedUser.lastname,
                            },
                        ],
                    },
                ],
            },
        }, {
            headers: {
                'Content-Type': 'application/json',
                Authorization: 'Bearer EAAFVXw8ns9ABO7hGWIU57K1PZBOlvDtylqUt8AfVF5AXt5i8aTZAa2qeqcVpE9eorejrLggCrIgBau77usFS7CZAZAtXxyl2RK9Mh4Qhw4ZBPUq6s4ArkvM8VfPVnNm58ua6jXhOTzhfqCcrSzPzpjpSniq36tGKICBxqEjJfqSfK68Vqbb0stCuORwOd6kGEHGCPFHOIQlsiC9R2FDXdGHxpZBZBXTZCEcyrU4nw1wLugnjS5T2OtvIhjYZB00EiZAV6I2sjsEuvC5QZDZD',
            },
        });
        const response = await axios.post('https://graph.facebook.com/v23.0/709680682221149/messages', {
            messaging_product: 'whatsapp',
            to: phone,
            type: 'template',
            template: {
                name: 'verification_otp',
                language: {
                    code: 'en',
                },
                components: [
                    {
                        type: 'body',
                        parameters: [
                            {
                                type: 'text',
                                text: newotp,
                            },
                        ],
                    },
                    {
                        type: 'button',
                        sub_type: 'url',
                        index: 0,
                        parameters: [
                            {
                                type: 'text',
                                text: newotp,
                            },
                        ],
                    },
                ],
            },
        }, {
            headers: {
                'Content-Type': 'application/json',
                Authorization: 'Bearer EAAFVXw8ns9ABO7hGWIU57K1PZBOlvDtylqUt8AfVF5AXt5i8aTZAa2qeqcVpE9eorejrLggCrIgBau77usFS7CZAZAtXxyl2RK9Mh4Qhw4ZBPUq6s4ArkvM8VfPVnNm58ua6jXhOTzhfqCcrSzPzpjpSniq36tGKICBxqEjJfqSfK68Vqbb0stCuORwOd6kGEHGCPFHOIQlsiC9R2FDXdGHxpZBZBXTZCEcyrU4nw1wLugnjS5T2OtvIhjYZB00EiZAV6I2sjsEuvC5QZDZD',
            },
        });
        const plain = "Dear " + savedUser.firstname + ' ' + savedUser.lastname + ", You have been successfully registered for the Travancore Cochin Heritage Auction. Thank you for choosing us! We’re excited to have you joined us for this extraordinary event. Your Registration Number is THA" + savedUser.regno + ". Your login username is " + email + " and password is " + password + " , Use this OTP: " + newotp + " to verify your account when you login.";
        const content = "<h3>Dear " + savedUser.firstname + ' ' + savedUser.lastname + ",</h3> <p>You have been successfully registered for the Travancore Cochin Heritage Auction. <br><br>Thank you for choosing us! We’re excited to have you joined us for this extraordinary event.</p><p> Click <a href='https://travancoreheritageauction.com/auction/login'>here</a> to Login</p><p>Your Registration Number is THA" + savedUser.regno + ".</p><p>Your login username is " + email + " and password is " + password + " </p><p>Use this OTP: " + newotp + " to verify your account when you login.</p>";
        console.log(this.sendEmail(savedUser.email, savedUser.firstname + ' ' + savedUser.lastname, plain, content, 'Welcome to Travancore Heritage Auction!'));
        const adminplain = "Dear Admin, New Customer Registration Alert. Customer Name: " + savedUser.firstname + ' ' + savedUser.lastname + ", Customer ID: THA" + savedUser.regno + ". Mobile Number: " + savedUser.phone + ". Please review and verify the details.";
        const admincontent = "<h3>Dear Admin, New Customer Registration Alert.</h3><br><br><p> Customer Name: " + savedUser.firstname + ' ' + savedUser.lastname + ",<br>Customer ID: THA" + savedUser.regno + "<br>Mobile Number: " + savedUser.phone + "<br><br>Please review and verify the details.</p>";
        this.sendEmail('travancoreheritageauction@gmail.com', savedUser.firstname + ' ' + savedUser.lastname, adminplain, admincontent, 'New Customer Registration Alert');
        return newUser;
    }
    async getAllUsers() {
        return this.userModel.find().exec();
    }
    async getUserById(id) {
        return this.userModel.findById(id).exec();
    }
    async updateUser(id, updateUserDto, newImages) {
        const existingUser = await this.userModel.findById(id);
        if (!existingUser) {
            throw new Error(`User with id ${id} does not exist`);
        }
        if (!existingUser.idproof || !Array.isArray(existingUser.idproof)) {
            await this.userModel.updateOne({ _id: id }, { $set: { idproof: [] } });
        }
        const updatedUser = await this.userModel.findByIdAndUpdate(id, {
            $set: updateUserDto,
            ...(newImages.length > 0 && { $push: { idproof: { $each: newImages } } }),
        }, { new: true }).exec();
        if (!updatedUser) {
            throw new common_1.NotFoundException(`User with id ${id} not found`);
        }
        return updatedUser;
    }
    async deleteDocs(body) {
        console.log(body.image);
        if (!body.image) {
            return {
                statuscode: 'failed',
                message: 'Missing Image',
            };
        }
        await this.userModel.findByIdAndUpdate(body.id, { $pull: { idproof: body.image } }, { new: true }).exec();
        return {
            statuscode: 'success',
            message: 'Document Removed',
        };
    }
    async deleteUser(id) {
        return this.userModel.findByIdAndDelete(id).exec();
    }
    async sendWelcomeEmail(email, password) {
    }
    async findByEmail(email) {
        return this.userModel.findOne({ email }).exec();
    }
    async comparePasswords(plainPassword, hashedPassword) {
        const bcrypt = require('bcrypt');
        return bcrypt.compare(plainPassword, hashedPassword);
    }
    async login(loginUserDto) {
        const { email, password } = loginUserDto;
        console.log(loginUserDto);
        const user = await this.userModel.findOne({ email });
        if (!user) {
            throw new common_1.NotFoundException('User not found');
        }
        const isPasswordValid = await bcrypt.compare(password, user.password);
        if (!isPasswordValid) {
            return {
                status: 'failed',
                message: 'Invalid credentials',
                data: '',
            };
        }
        if (user.userRole === 'user' && user.userType === 'user') {
            return {
                status: 'success',
                message: 'Login successful',
                data: {
                    userId: user._id,
                    email: user.email,
                    role: 'user',
                    type: 'user',
                },
            };
        }
        if (user.userRole === 'staff' || user.userRole === 'admin') {
            return {
                status: 'success',
                message: 'Login successful',
                data: {
                    userId: user._id,
                    email: user.email,
                    role: user.userRole,
                    type: user.userType,
                },
            };
        }
        throw new common_1.UnauthorizedException('Invalid user role or type');
    }
    async getInactiveUsers() {
        return this.userModel.find({ status: 0 }).exec();
    }
    async approveUser(id) {
        const userdata = await this.userModel.find({ _id: id }).exec();
        const savedUser = userdata[0];
        if (!savedUser) {
            return {
                status: 'failed',
                message: 'Invalid User',
            };
        }
        const plain = "Namaste! We are delighted to inform you that your bid limit has been approved by our team at Travancore Heritage Auction! A warm welcome to Kerala's first and most trusted auction house! We are thrilled to have you on board as a valued customer. Your trust in us is our greatest honor. We look forward to serving you with the finest numismatic, philatelic, and antique collectibles. Our team is committed to providing you with an unparalleled auction experience. Thank you for choosing Travancore Heritage Auction. We are excited to partner with you in your collecting journey! Best regards, Travancore Heritage Auction Team. Please don't hesitate to get in touch if you have any questions or enquiries. Contact Us: www.travancoreheritageauction.com, www.numisheritageindia@gmail.com. Phone Number 8848044033/ 7510624987.";
        const content = "<h3>Namaste</h3> <p>We are delighted to inform you that your bid limit has been approved by our team at Travancore Heritage Auction! <br><br>A warm welcome to Kerala's first and most trusted auction house! We are thrilled to have you on board as a valued customer. <br><br>We look forward to serving you with the finest numismatic, philatelic, and antique collectibles. Our team is committed to providing you with an unparalleled auction experience. <br><br>Thank you for choosing Travancore Heritage Auction. We are excited to partner with you in your collecting journey!<br><br>Best regards,<br>Travancore Heritage Auction Team<br><br>Please don't hesitate to get in touch if you have any questions or enquiries<br><br>Contact Us:<br><a href='https://www.travancoreheritageauction.com'>www.travancoreheritageauction.com</a><br><a href='mailto:numisheritageindia@gmail.com'>numisheritageindia@gmail.com</a><br><br>Phone Number 8848044033/ 7510624987</p>";
        console.log(this.sendEmail(savedUser.email, savedUser.firstname + ' ' + savedUser.lastname, plain, content, 'Bid Limit Approval - Travancore Heritage Auction!'));
        return this.userModel.findByIdAndUpdate(id, { status: 1 }, { new: true }).exec();
    }
    async approveOTP(id) {
        return this.userModel.findByIdAndUpdate(id, { otpstatus: 1 }, { new: true }).exec();
    }
    async resendOTP(body) {
        const userdata = await this.userModel.find({ email: body.email }).exec();
        const user = userdata[0];
        console.log(user);
        if (!user) {
            return {
                status: 'failed',
                message: 'Invalid User',
            };
        }
        const digits = '0123456789';
        let newotp = '';
        for (let i = 0; i < 6; i++) {
            newotp += digits[Math.floor(Math.random() * digits.length)];
        }
        await this.userModel.findOneAndUpdate({ email: body.email }, {
            $set: { otp: newotp }
        }, { new: true, upsert: true });
        const plain = "Dear " + user.firstname + ' ' + user.lastname + ", Use this OTP: " + newotp + " to reset your password.";
        const content = "<h3>Dear " + user.firstname + ' ' + user.lastname + ",</h3> <p>Use this OTP: " + newotp + " to reset your password.</p>";
        await this.sendEmail(user.email, user.firstname + ' ' + user.lastname, plain, content, 'Change Password OTP - Travancore Heritage Auction!');
        return {
            status: 'success',
            message: 'OTP Sent succesfully',
        };
    }
    async resetPassword(body) {
        const user = await this.userModel.find({ email: body.email }).exec();
        if (!user) {
            return {
                status: 'failed',
                message: 'Invalid User',
            };
        }
        console.log(user);
        if (body.otp != user[0].otp) {
            return {
                status: 'failed',
                message: 'Invalid OTP. Please try again',
            };
        }
        const hashedPassword = await bcrypt.hash(body.newpassword, 10);
        await this.userModel.findByIdAndUpdate(user[0]._id, { password: hashedPassword }, { new: true }).exec();
        return {
            status: 'success',
            message: 'Password changed succesfully',
        };
    }
    async updateBidAmount(body) {
        this.userModel.findByIdAndUpdate(body.id, { status: 0 }).exec();
        this.userModel.findByIdAndUpdate(body.id, { maxBidAmount: body.maxBidAmount }).exec();
        const suser = await this.userModel.find({ _id: body.id }).exec();
        const savedUser = suser[0];
        const adminplain = "Dear Admin, Bid Limit Request Notification. Customer Name: " + savedUser.firstname + ' ' + savedUser.lastname + ", Customer ID: THA" + savedUser.regno + ". Mobile Number: " + savedUser.phone + ". Request: Bid Limit Increase.";
        const admincontent = "<h3>Dear Admin, Bid Limit Request Notification.</h3><br><br><p> Customer Name: " + savedUser.firstname + ' ' + savedUser.lastname + ",<br>Customer ID: THA" + savedUser.regno + "<br>Mobile Number: " + savedUser.phone + "<br><br>Request: Bid Limit Increase.</p>";
        this.sendEmail('info@travancoreheritageauction.com', savedUser.firstname + ' ' + savedUser.lastname, adminplain, admincontent, 'Bid Limit Request Notification');
        return {
            status: 'success',
            message: 'Update successful. Your Bidding amount will be approved by Admin',
        };
    }
    async changePassword(body) {
        const user = await this.userModel.findById(body.id);
        if (!user) {
            return {
                status: 'failed',
                message: 'Invalid User',
            };
        }
        const isPasswordValid = await bcrypt.compare(body.currentpassword, user.password);
        if (!isPasswordValid) {
            return {
                status: 'failed',
                message: 'Invalid Current Password. Please try again',
            };
        }
        const hashedPassword = await bcrypt.hash(body.newpassword, 10);
        await this.userModel.findByIdAndUpdate(body.id, { password: hashedPassword }, { new: true }).exec();
        return {
            status: 'success',
            message: 'Password changed succesfully',
        };
    }
    async sendEmail(to, name, plain, content, subject) {
        const mailjetAPIKey = 'a827249b18ef476acc5eb882fca8c1dd';
        const mailjetAPISecret = '8fb49d646c35592d0814f9ae7da771c4';
        const mailData = {
            Messages: [
                {
                    From: {
                        Email: "info@travancoreheritageauction.com",
                        Name: "Travancore Heritage Auction"
                    },
                    To: [
                        {
                            Email: to,
                            Name: name
                        }
                    ],
                    Subject: subject,
                    TextPart: plain,
                    HTMLPart: content
                }
            ]
        };
        try {
            const response = await axios.post('https://api.mailjet.com/v3.1/send', mailData, {
                headers: { 'Content-Type': 'application/json' },
                auth: {
                    username: mailjetAPIKey,
                    password: mailjetAPISecret
                }
            });
            return 1;
        }
        catch (error) {
            return 2;
        }
    }
    ;
    async send() {
        const plain = "Dear Sir, You have been successfully registered for the Travancore Cochin Heritage Auction. Thank you for choosing us! We’re excited to have you joined us for this extraordinary event.";
        const content = "<h3>Dear Sir,</h3> <br><p>You have been successfully registered for the Travancore Cochin Heritage Auction. <br><br>Thank you for choosing us! We’re excited to have you joined us for this extraordinary event.</p><p> Click <a href='https://travancoreheritageauction.com/auction/login'>here</a> to Login</p>";
        console.log(this.sendEmail('roopjithvn@gmail.com', 'Roopjith VN', plain, content, 'Welcome to Travancore Heritage Auction!'));
    }
    async createData(body, user) {
        const currentTime = new Date();
        const newData = new this.previousdataModel({
            user: user,
            name: body.name,
            city: body.city,
            phone: body.phone,
            type: body.type,
            timestamps: currentTime,
        });
        await newData.save();
        return {
            statuscode: 'success',
            message: 'Data Saved Sucessfully',
        };
    }
    async getData(user) {
        return await this.previousdataModel.find({ user: user }).exec();
    }
    async deleteData(body, user) {
        return await this.previousdataModel.findByIdAndDelete(body.id).exec();
    }
    async getUserData(body) {
        return await this.previousdataModel.find({ user: body.id }).exec();
    }
    async getTotalUsersCount() {
        var count = await this.userModel.countDocuments().exec();
        return {
            statuscode: 'success',
            count: count,
        };
    }
};
exports.UsersService = UsersService;
exports.UsersService = UsersService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(user_schema_1.User.name)),
    __param(1, (0, mongoose_1.InjectModel)(previousdata_schema_1.Previousdata.name)),
    __metadata("design:paramtypes", [mongoose_2.Model,
        mongoose_2.Model,
        email_service_1.EmailService])
], UsersService);
//# sourceMappingURL=users.service.js.map