import { Module } from '@nestjs/common';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { AuthModule } from './auth/auth.module';
import { UsersModule } from './users/users.module';
import { MongooseModule } from '@nestjs/mongoose';
import { CategoriesModule } from './categories/categories.module';
import { ProductModule } from './products/product.module';
import { SettingsModule } from './settings/settings.module';
import { PaymentModule } from './payment/payment.module';
import { ConfigModule } from '@nestjs/config';
import { ServeStaticModule } from '@nestjs/serve-static';
import { join } from 'path';

@Module({
  imports: [
    /*MongooseModule.forRoot('mongodb+srv://auc_user:PuLfMf9V6d1Lrsjy@cluster0.njfu2sx.mongodb.net/auction?retryWrites=true&w=majority&appName=Cluster0', {
      autoIndex: true, // Ensure indexes are created on startup
    }),*/
    MongooseModule.forRoot(
      'mongodb://aucadmin:%3Fa%3CeE%3Bw8%7Dap%23@localhost:27017/auction?authSource=auction',
    ),
    ServeStaticModule.forRoot({
      rootPath: join(__dirname, '..', 'uploads'), // Path to your uploads folder
      serveRoot: '/uploads', // URL prefix
      exclude: ['/api*'], // Optional: Exclude serving static files on API routes
    }),
    AuthModule,
    UsersModule,
    CategoriesModule,
    ProductModule,
    SettingsModule,
    PaymentModule,
    ConfigModule.forRoot({
      isGlobal: true, // Makes ConfigModule available globally
    }),
  ],
  controllers: [AppController],
  providers: [AppService],
})
export class AppModule {}
