import { IsNotEmpty, IsString, IsNumber, IsBoolean, IsOptional } from 'class-validator';
import { Transform } from 'class-transformer';
import { Types } from 'mongoose';

export class CategoryDto {
  @IsNotEmpty()
  @IsString()
  name: string;

  @IsOptional()
  @IsString()
  description?: string;

  @IsOptional()  
  @Transform(({ value }) => (value ? new Types.ObjectId(value.trim()) : value), { toClassOnly: true })
  category: Types.ObjectId;

  @IsOptional()
  @IsString()
  image?: string;
}
