import { NestFactory } from '@nestjs/core';
import { AppModule } from './app.module';
import { ValidationPipe } from '@nestjs/common';
import * as cors from 'cors';
import * as dotenv from 'dotenv';
import * as bodyParser from 'body-parser';
import * as fs from 'fs';
import * as https from 'https';
import * as path from 'path';

async function bootstrap() {

  const httpsOptions = {
    key: fs.readFileSync(path.join(__dirname, '../src/certificates/private.key')), // Adjust path relative to `dist`
    cert: fs.readFileSync(path.join(__dirname, '../src/certificates/certificate.crt')),
    ca: fs.readFileSync(path.join(__dirname, '../src/certificates/ca_bundle.crt')),
  };
  const app = await NestFactory.create(AppModule, {
    httpsOptions,
  });

  app.use(bodyParser.urlencoded({ extended: true }));

  app.use(cors());

  // Enable validation globally
  app.useGlobalPipes(new ValidationPipe({ transform: true }));
  
  await app.listen(process.env.PORT ?? 3035);
}
bootstrap();
