//import { Controller, Post, Body } from '@nestjs/common';
import {  Controller,  Get, Req, Post,  Query,  Body,  Param,  Put,  Delete,  UploadedFiles,  UseInterceptors,  UseGuards,  BadRequestException, UsePipes, ValidationPipe} from '@nestjs/common';
import { FilesInterceptor } from '@nestjs/platform-express';
import { diskStorage } from 'multer';
import { PaymentService } from './payment.service';
import { extname } from 'path';
import { JwtAuthGuard } from '../auth/jwt-auth.guard';
const mongoose = require('mongoose');


@Controller('payment')
export class PaymentController {
  constructor(private readonly paymentService: PaymentService) {}

  @UseGuards(JwtAuthGuard)
  @Post('create-order')
  async createOrder(@Body() body: any,@Req() req) {
    return this.paymentService.createOrder(body,req.user.userId);
  }

  @UseGuards(JwtAuthGuard)
  @Post('verify-payment')
  async verifyPayment(@Body() body: { orderId: string; paymentId: string; signature: string },@Req() req) {
    return this.paymentService.verifyPaymentSignature(body.orderId, body.paymentId, body.signature,req.user.userId);
  }

  @UseGuards(JwtAuthGuard)
  @Post('get-order')
  async getOrder(@Body() body: any,@Req() req) {
    return this.paymentService.getOrder(body,req.user.userId);
  }

  @UseGuards(JwtAuthGuard)
  @Post('get-my-orders')
  async getMyOrders(@Body() body: any,@Req() req) {
    return this.paymentService.getMyOrders(body,req.user.userId);
  }

  @UseGuards(JwtAuthGuard)
  @Post('get-all-orders')
  async getAllOrders(@Body() body: any,@Req() req) {
    return this.paymentService.getAllOrders(body,req.user.userId);
  }
}
