import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Types } from 'mongoose';

export type OrderDocument = Order & Document;

@Schema({ timestamps: true })
export class Order extends Document {
  @Prop({ type: Types.ObjectId, ref: 'User', required: true })
  user: Types.ObjectId;

  @Prop([
    {
      productId: { type: Types.ObjectId, ref: 'Product', required: true },
      quantity: { type: Number, required: true },
      status: { type: Number, default: '0' }
    },
  ])
  items: { productId: Types.ObjectId; quantity: number }[];

  @Prop({ required: true, type: Number })
  amount: number;

  @Prop({ required: true })
  receipt: String;

  @Prop({ required: true })
  orderId: String;

  @Prop()
  paymentId: String;

  @Prop()
  signature: String;

  @Prop()
  address1: String;

  @Prop()
  address2: String;

  @Prop()
  address3: String;

  @Prop()
  country: String;

  @Prop()
  city: String;

  @Prop()
  state: String;

  @Prop()
  pincode: String;

  @Prop({ default: '0' }) // Default value for status
  status: string;
}

export const OrderSchema = SchemaFactory.createForClass(Order);