import { IsOptional, IsInt, Min, IsString } from 'class-validator';
import { Type } from 'class-transformer';

export class PaginationQueryDto {
  @IsOptional()
  @Type(() => Number) // Ensure the value is transformed to a number
  @IsInt()
  @Min(1)
  page?: number = 1;

  @IsOptional()
  @Type(() => Number)
  @IsInt()
  @Min(1)
  limit?: number = 10;

  @IsOptional()
  @IsString()
  search?: string;

  @IsOptional()
  @IsString()
  category?: string;

  @IsOptional()
  @IsString()
  auction?: string;

  @IsOptional()
  fromprice?: number = 0;

  @IsOptional()
  toprice?: number = 9999999;
  
  @IsOptional()
  @IsString()
  itemstatus?: string;
  
  @IsOptional()
  @IsString()
  material?: string;
}
