import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Types } from 'mongoose';

export type BidDocument = Bid & Document;

@Schema({ timestamps: true })
export class Bid extends Document {

	@Prop({ type: Types.ObjectId, ref: 'User', required: true })
  	user: Types.ObjectId;

  	@Prop({ type: Types.ObjectId, ref: 'Product', required: true })
  	product: Types.ObjectId;

  	@Prop({ required: true, type: Number })
	bidAmount: number;
	
	@Prop()
    remark: string;

	@Prop()
	createdAt?: Date; // Add createdAt explicitly

	@Prop()
	updatedAt?: Date; // Add updatedAt explicitly

}

export const BidSchema = SchemaFactory.createForClass(Bid);