import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Types } from 'mongoose';

//export type ProductDocument = Product & Document;

@Schema()
export class Product extends Document {
  @Prop()
  name: string;

  @Prop()
  description: string;

  @Prop()
  shortDescription: string;

  @Prop()
  auctionItemCondition: string;

  @Prop()
  auctionType: string;

  @Prop({ type: Number })
  startPrice: number;

  @Prop({ type: Number })
  bidIncrement: number;

  @Prop({ type: Number })
  reservePrice: number;

  @Prop({ type: Number, default: 0 })
  userReservePrice: number;

  @Prop({ type: Number })
  buyItNowPrice: number;

  @Prop({ type: Date })
  auctionStartDate: Date;

  @Prop({ type: Date })
  auctionEndDate: Date;

  @Prop({ type: Date, default: null })
  productDate: Date;

  @Prop({ type: Boolean, default: false })
  extendAuctionOnBid: boolean;

  @Prop({ type: Boolean, default: false })
  extendAuctionInLastSecond: boolean;

  @Prop({ type: Number })
  extendAuctionForSeconds: number;

  @Prop({ type: Types.ObjectId, ref: 'Category', required: true })
  category: Types.ObjectId;

  @Prop({ type: [String], validate: [(val: string[]) => val.length <= 5, 'Maximum 5 images allowed'] })
  images: string[];

  @Prop({ type: [String] })
  tags: string[];

  @Prop({ unique: true })
  sku: string;

  @Prop()
  lotNumber: number;

  @Prop()
  hsncode: string;

  @Prop()
  yearOfOrigin: string;

  @Prop()
  material: string;

  @Prop()
  mintMark: string;

  @Prop()
  grade: string;

  @Prop()
  rarity: string;

  @Prop()
  weight: string;

  @Prop()
  size: string;

  @Prop()
  diameter: string;

  @Prop({ default: '0' }) // Default value for userType
  lotstart: string;

  @Prop({ type: Types.ObjectId, ref: 'User', default: null })
  finaluser: Types.ObjectId;

  @Prop({ default:'' })
  finalamount: string;

  @Prop({ default:'' })
  isbanner: string;

  @Prop({ default: '0' }) // Default value for auctionStatus
  auctionStatus: string;

}

export const ProductSchema = SchemaFactory.createForClass(Product);