import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Types } from 'mongoose';

export type ReserveDocument = Reserve & Document;

@Schema({ timestamps: true })
export class Reserve extends Document {

	@Prop({ type: Types.ObjectId, ref: 'User', required: true })
  	user: Types.ObjectId;

  	@Prop({ type: Types.ObjectId, ref: 'Product', required: true })
  	product: Types.ObjectId;

  	@Prop({ required: true, type: Number })
	reserveAmount: number;

	@Prop()
	createdAt?: Date; // Add createdAt explicitly

	@Prop()
	updatedAt?: Date; // Add updatedAt explicitly

}

export const ReserveSchema = SchemaFactory.createForClass(Reserve);