import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Types } from 'mongoose';

export type ResultDocument = Result & Document;

@Schema({ timestamps: true })
export class Result extends Document {

  	@Prop({ type: Types.ObjectId, ref: 'Product', required: true })
  	product: Types.ObjectId;

  	@Prop({ default: '0' }) // Default value for auctionStatus
  	auctionStatus: string;

	@Prop()
	createdAt?: Date; // Add createdAt explicitly

	@Prop()
	updatedAt?: Date; // Add updatedAt explicitly

}

export const ResultSchema = SchemaFactory.createForClass(Result);