import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Types } from 'mongoose';

export type VideoDocument = Video & Document;

@Schema({ timestamps: true })
export class Video extends Document {

	@Prop({ type: Types.ObjectId, ref: 'User', required: true })
  	user: Types.ObjectId;

  	@Prop({ type: Types.ObjectId, ref: 'Product', required: true })
  	product: Types.ObjectId;

	@Prop()
	createdAt?: Date; // Add createdAt explicitly

	@Prop()
	updatedAt?: Date; // Add updatedAt explicitly

}

export const VideoSchema = SchemaFactory.createForClass(Video);