import { Module, forwardRef  } from '@nestjs/common';
import { MongooseModule } from '@nestjs/mongoose';
import { ServeStaticModule } from '@nestjs/serve-static';
import { join } from 'path';
import { SettingsService } from './settings.service';
import { SettingsController } from './settings.controller';
import { Setting, SettingSchema } from './setting.schema';
import { AuthModule } from '../auth/auth.module';
import { EmailModule } from '../email/email.module';
import { Banner, BannerSchema } from './banner.schema';

@Module({
  imports: [
    MongooseModule.forFeature([{ name: Setting.name, schema: SettingSchema }]), // Register User schema
    MongooseModule.forFeature([{ name: Banner.name, schema: BannerSchema }]),
    forwardRef(() => AuthModule),
    EmailModule
  ],
  controllers: [SettingsController],
  providers: [SettingsService],
})
export class SettingsModule {}
