import { ConflictException, Injectable, NotFoundException, UnauthorizedException } from '@nestjs/common';
import { InjectModel } from '@nestjs/mongoose';
import { Model } from 'mongoose';
import { SettingsDto } from './settings.dto';
import { Setting, SettingSchema } from './setting.schema';
import { Banner, BannerSchema } from './banner.schema';

@Injectable()
export class SettingsService {
  constructor(
    @InjectModel(Setting.name) private settingsModel: Model<Setting>,
    @InjectModel(Banner.name) private bannerModel: Model<Banner>,
  ) {}

  async createIncrement(settingsDto: SettingsDto): Promise<Setting> {
    const newSetting = new this.settingsModel(settingsDto);
    return newSetting.save();
  }

  async findAll(): Promise<Setting[]> {
    return this.settingsModel.find().sort({ fromamount: 1 }).exec();
  }

  async delete(id: string): Promise<any> {
    return this.settingsModel.findByIdAndDelete(id).exec();
  }

  async addBanner(body,user,images): Promise<any> {
    console.log(images);
    const newBanner = new this.bannerModel({
      images: images[0],
    });

    await newBanner.save();
    return {
      statuscode:'success',
      message: 'Banner added.',
    };
  }

  async getBanners(): Promise<any> {
    return this.bannerModel.find().exec();
  }

  async removeBanner(body): Promise<any> {
    const result = await this.bannerModel.findByIdAndDelete(body.id).exec();
    if (!result) {
      throw new NotFoundException(`Banner with id ${body.id} not found`);
    } else {
      return {
        statuscode:'success',
        message: 'Banner removed',
      };
    }
  }
}
