import { IsEmail, IsNotEmpty, IsString, Matches, IsNumber, MinLength, IsOptional, Min  } from 'class-validator';
import { Type, Transform } from 'class-transformer';

export class CreateUserDto {
  @IsNotEmpty()
  @IsString()
  firstname: string;

  @IsNotEmpty()
  @IsString()
  lastname: string;

  @IsNotEmpty()
  @IsEmail()
  email: string;

  @IsOptional()
  phone: string;

  @Type(() => Number)
  @IsNumber()
  @Min(0)
  maxBidAmount: number;

  @IsNotEmpty()
  @MinLength(8, {
    message: 'Password must be at least 8 characters long',
  })
  password: string;

  @IsString()
  @IsOptional()
  userRole: string = 'user'; // Default value

  @IsString()
  @IsOptional()
  userType: string = 'user'; // Default value

  @IsOptional()
  otp: number = 0;

  @IsOptional()
  otpstatus: number = 0;

  @IsOptional()
  status: number = 0;

  @IsOptional()
  dob?: Date = null;

  @IsOptional()
  pan: string = '';

  @IsOptional()
  idproof?: string[];

  @IsOptional()
  whatsapp: string = '';

  @IsOptional()
  address1: string = '';

  @IsOptional()
  address2: string = '';

  @IsOptional()
  address3: string = '';

  @IsOptional()
  country: string = '';

  @IsOptional()
  state: string = '';

  @IsOptional()
  city: string = '';

  @IsOptional()
  pincode: string = '';

  @IsOptional()
  accountno: string = '';

  @IsOptional()
  bank: string = '';

  @IsOptional()
  ifsc: string = '';

  @IsOptional()
  location: string = '';
}
