import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Types } from 'mongoose';

export type PreviousdataDocument = Previousdata & Document;

@Schema({ timestamps: true })
export class Previousdata extends Document {

  @Prop({ type: Types.ObjectId, ref: 'User', required: true })
  user: Types.ObjectId;

  @Prop({ required: true })
  name: string;

  @Prop({ required: true })
  city: string;

  @Prop({ required: true })
  phone: string;

  @Prop({ default:'bidding' })
  type: string;

  @Prop()
  createdAt?: Date; // Add createdAt explicitly

  @Prop()
  updatedAt?: Date; // Add updatedAt explicitly

}

export const PreviousdataSchema = SchemaFactory.createForClass(Previousdata);