import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document } from 'mongoose';


@Schema()
export class User extends Document {
  @Prop({ required: true })
  firstname: string;

  @Prop({ default:0 })
  regno: number;

  @Prop({ required: true })
  lastname: string;

  @Prop({ required: true, unique: true })
  email: string;

  @Prop()
  phone: string;

  @Prop({ type: Number, required: true })
  maxBidAmount: number;

  @Prop({ required: true })
  password: string;

  @Prop({ default: 'user' }) // Default value for userRole
  userRole: string;

  @Prop({ default: 'user' }) // Default value for userType
  userType: string;

  @Prop({ default: 0 })
  otp: number;

  @Prop({ default: 0 })
  otpstatus: number;

  @Prop({ default: 0 })
  status: number;

  @Prop({ type: Date, default:null })
  dob: Date;

  @Prop({ default: null })
  pan: string;

  @Prop({ default: null })
  idproof: string[];

  @Prop({ default: null })
  whatsapp: string;

  @Prop({ default: null })
  address1: string;

  @Prop({ default: null })
  address2: string;

  @Prop({ default: null })
  address3: string;

  @Prop({ default: null })
  country: string;

  @Prop({ default: null })
  state: string;

  @Prop({ default: null })
  city: string;

  @Prop({ default: null })
  pincode: string;

  @Prop({ default: null })
  accountno: string;

  @Prop({ default: null })
  bank: string;

  @Prop({ default: null })
  ifsc: string;

  @Prop({ default: null })
  location: string;
}

export type UserDocument = User & Document;
export const UserSchema = SchemaFactory.createForClass(User);
