import { ConflictException, Injectable, NotFoundException, UnauthorizedException } from '@nestjs/common';
import { InjectModel } from '@nestjs/mongoose';
import { Model } from 'mongoose';
import { User, UserDocument } from './schemas/user.schema';
import { Previousdata } from './schemas/previousdata.schema';
import * as bcrypt from 'bcrypt';
import { CreateUserDto } from './dto/create-user.dto';
import { LoginUserDto } from './dto/login-user.dto';
import { EmailService } from '../email/email.service';
const axios = require('axios');


@Injectable()
export class UsersService {
  constructor(
    @InjectModel(User.name) private userModel: Model<User>, 
    @InjectModel(Previousdata.name) private previousdataModel: Model<Previousdata>,
    private readonly emailService: EmailService,
  ) {}

  // Create a new user
  async createUser(createUserDto: any): Promise<User> {
  	const { firstname, lastname, email, phone, maxBidAmount, usertype, userrole, otp, otpstatus, password } = createUserDto;

	// Check if email already exists
	const existingUser = await this.userModel.findOne({ email });
	if (existingUser) {
	   throw new ConflictException('Email already exists');
	}

  	// Generate a random password
    //const randomPassword = Math.random().toString(36).slice(-8);

    const digits = '0123456789';
    let newotp = '';
    for (let i = 0; i < 6; i++) {
      newotp += digits[Math.floor(Math.random() * digits.length)];
    }

    // Hash the password
    const hashedPassword = await bcrypt.hash(password, 10);
    const newregno = await this.userModel.countDocuments()+1;


    const newUser = new this.userModel({
      regno:newregno,
      firstname,
      lastname,
      email,
      phone,
      maxBidAmount,
      userrole,
      usertype,
      otp:newotp,
      otpstatus,
      password: hashedPassword,
    });

    const savedUser = await newUser.save();

    // Send email with the generated password
    // Send a welcome email
    /*await this.emailService.sendEmail(
      savedUser.email,
      'Welcome to Our App!',
      `Hello ${savedUser.firstname} ${savedUser.lastname}, welcome to our platform!`,
      `<h1>Hello ${savedUser.firstname} ${savedUser.lastname},</h1><p>Welcome to our platform!</p>`,
    );*/
    
    const wresponse = await axios.post(
      'https://graph.facebook.com/v23.0/709680682221149/messages',
      {
        messaging_product: 'whatsapp',
        to: phone,
        type: 'template',
        template: {
          name: 'user_registration',
          language: {
            code: 'en',
          },
          components: [
            {
              type: 'body',
              parameters: [
                {
                  type: 'text',
                  parameter_name:'name',
                  text: savedUser.firstname + ' ' + savedUser.lastname, // Dynamic text value for the template placeholder
                },
              ],
            },
          ],
        },
      },
      {
        headers: {
          'Content-Type': 'application/json',
          Authorization: 'Bearer EAAFVXw8ns9ABO7hGWIU57K1PZBOlvDtylqUt8AfVF5AXt5i8aTZAa2qeqcVpE9eorejrLggCrIgBau77usFS7CZAZAtXxyl2RK9Mh4Qhw4ZBPUq6s4ArkvM8VfPVnNm58ua6jXhOTzhfqCcrSzPzpjpSniq36tGKICBxqEjJfqSfK68Vqbb0stCuORwOd6kGEHGCPFHOIQlsiC9R2FDXdGHxpZBZBXTZCEcyrU4nw1wLugnjS5T2OtvIhjYZB00EiZAV6I2sjsEuvC5QZDZD',
        },
      },


    );

    const response = await axios.post(
      'https://graph.facebook.com/v23.0/709680682221149/messages',
      {
        messaging_product: 'whatsapp',
        to: phone,
        type: 'template',
        template: {
          name: 'verification_otp',
          language: {
            code: 'en',
          },
          components: [
            {
              type: 'body',
              parameters: [
                {
                  type: 'text',
                  text: newotp, // Dynamic text value for the template placeholder
                },
              ],
            },
            {
              type: 'button',
              sub_type: 'url',
              index: 0,
              parameters: [
                {
                  type: 'text',
                  text: newotp, // Value to replace {{1}} in the button's URL template
                },
              ],
            },
          ],
        },
      },
      {
        headers: {
          'Content-Type': 'application/json',
          Authorization: 'Bearer EAAFVXw8ns9ABO7hGWIU57K1PZBOlvDtylqUt8AfVF5AXt5i8aTZAa2qeqcVpE9eorejrLggCrIgBau77usFS7CZAZAtXxyl2RK9Mh4Qhw4ZBPUq6s4ArkvM8VfPVnNm58ua6jXhOTzhfqCcrSzPzpjpSniq36tGKICBxqEjJfqSfK68Vqbb0stCuORwOd6kGEHGCPFHOIQlsiC9R2FDXdGHxpZBZBXTZCEcyrU4nw1wLugnjS5T2OtvIhjYZB00EiZAV6I2sjsEuvC5QZDZD',
        },
      },


    );
    
    /*const adminresponse = await axios.post(
      'https://graph.facebook.com/v23.0/709680682221149/messages',
      {
        messaging_product: 'whatsapp',
        to: '919961267363',
        type: 'template',
        template: {
          name: 'new_user_reg_admin_notification',
          language: {
            code: 'en',
          },
          components: [
            {
              type: 'body',
              parameters: [
                {
                  type: 'text',
                  parameter_name:'name',
                  text: savedUser.firstname + ' ' + savedUser.lastname, // Dynamic text value for the template placeholder
                },
              ],
            },
          ],
        },
      },
      {
        headers: {
          'Content-Type': 'application/json',
          Authorization: 'Bearer EAAFVXw8ns9ABO7hGWIU57K1PZBOlvDtylqUt8AfVF5AXt5i8aTZAa2qeqcVpE9eorejrLggCrIgBau77usFS7CZAZAtXxyl2RK9Mh4Qhw4ZBPUq6s4ArkvM8VfPVnNm58ua6jXhOTzhfqCcrSzPzpjpSniq36tGKICBxqEjJfqSfK68Vqbb0stCuORwOd6kGEHGCPFHOIQlsiC9R2FDXdGHxpZBZBXTZCEcyrU4nw1wLugnjS5T2OtvIhjYZB00EiZAV6I2sjsEuvC5QZDZD',
        },
      },


    );*/

    const plain = "Dear " + savedUser.firstname + ' ' + savedUser.lastname + ", You have been successfully registered for the Travancore Cochin Heritage Auction. Thank you for choosing us! We’re excited to have you joined us for this extraordinary event. Your Registration Number is THA"+savedUser.regno+". Your login username is " + email + " and password is " + password + " , Use this OTP: " + newotp + " to verify your account when you login.";
    const content = "<h3>Dear " + savedUser.firstname + ' ' + savedUser.lastname + ",</h3> <p>You have been successfully registered for the Travancore Cochin Heritage Auction. <br><br>Thank you for choosing us! We’re excited to have you joined us for this extraordinary event.</p><p> Click <a href='https://travancoreheritageauction.com/auction/login'>here</a> to Login</p><p>Your Registration Number is THA"+savedUser.regno+".</p><p>Your login username is " + email + " and password is " + password + " </p><p>Use this OTP: " + newotp + " to verify your account when you login.</p>";
    console.log(this.sendEmail(savedUser.email,savedUser.firstname + ' ' + savedUser.lastname,plain,content,'Welcome to Travancore Heritage Auction!'));
    const adminplain = "Dear Admin, New Customer Registration Alert. Customer Name: " + savedUser.firstname + ' ' + savedUser.lastname + ", Customer ID: THA"+savedUser.regno+". Mobile Number: "+savedUser.phone+". Please review and verify the details.";
    const admincontent = "<h3>Dear Admin, New Customer Registration Alert.</h3><br><br><p> Customer Name: " + savedUser.firstname + ' ' + savedUser.lastname + ",<br>Customer ID: THA"+savedUser.regno+"<br>Mobile Number: "+savedUser.phone+"<br><br>Please review and verify the details.</p>";
    //this.sendEmail('info@travancoreheritageauction.com',''savedUser.firstname + ' ' + savedUser.lastname,adminplain,admincontent,'New Customer Registration Alert');
    this.sendEmail('travancoreheritageauction@gmail.com',savedUser.firstname + ' ' + savedUser.lastname,adminplain,admincontent,'New Customer Registration Alert');

    return newUser;
  }

  // Get all users
  async getAllUsers(): Promise<User[]> {

    return this.userModel.find().exec();
  }

  // Get a single user by ID
  async getUserById(id: string): Promise<User> {
    return this.userModel.findById(id).exec();
  }

  // Update a user by ID
  async updateUser(id: string, updateUserDto: any,newImages: string[]): Promise<User> {
    // Step 1: Check if the document exists
    const existingUser = await this.userModel.findById(id);
    if (!existingUser) {
      throw new Error(`User with id ${id} does not exist`);
    }
    
    // Step 2: Initialize 'idproof' if it doesn't exist
    if (!existingUser.idproof || !Array.isArray(existingUser.idproof)) {
      await this.userModel.updateOne(
        { _id: id },
        { $set: { idproof: [] } }
      );
    }

    const updatedUser = await this.userModel.findByIdAndUpdate(
      id,
      {
        $set: updateUserDto, // Update other fields
        ...(newImages.length > 0 && { $push: { idproof: { $each: newImages } } }), // Add new images
      },
      { new: true } // Return the updated document
    ).exec();

    if (!updatedUser) {
      throw new NotFoundException(`User with id ${id} not found`);
    }

    return updatedUser;

    //return this.userModel.findByIdAndUpdate(id, updateUserDto, { new: true }).exec();
  }
  
  

  async deleteDocs(body): Promise<any> {
    console.log(body.image);
    if(!body.image) {
      return {
        statuscode:'failed',
        message: 'Missing Image',
      };
    }
    await this.userModel.findByIdAndUpdate(
      body.id,
      { $pull: { idproof: body.image } },
      { new: true },
    ).exec();
    return {
      statuscode:'success',
      message: 'Document Removed',
    };
  }

  // Delete a user by ID
  async deleteUser(id: string): Promise<User> {
    return this.userModel.findByIdAndDelete(id).exec();
  }

  private async sendWelcomeEmail(email: string, password: string) {
    // Implement email sending here (see Step 5)
  }

  async findByEmail(email: string): Promise<User | null> {
    return this.userModel.findOne({ email }).exec();
  }

  async comparePasswords(plainPassword: string, hashedPassword: string): Promise<boolean> {
    const bcrypt = require('bcrypt');
    return bcrypt.compare(plainPassword, hashedPassword);
  }

  async login(loginUserDto: LoginUserDto) {
    const { email, password } = loginUserDto;
    console.log(loginUserDto);
    // Find user by email
    const user = await this.userModel.findOne({ email });
    if (!user) {

      throw new NotFoundException('User not found');
    }


    // Validate password
    const isPasswordValid = await bcrypt.compare(password, user.password);
    
    if (!isPasswordValid) {
      return {
        status: 'failed',
        message: 'Invalid credentials',
        data: '',
      };
    }

    // Check role and type
    if (user.userRole === 'user' && user.userType === 'user') {
      return {
        status: 'success',
        message: 'Login successful',
        data: {
          userId: user._id,
          email: user.email,
          role: 'user',
          type: 'user',
        },
      };
    }

    if (user.userRole === 'staff' || user.userRole === 'admin') {
      return {
        status: 'success',
        message: 'Login successful',
        data: {
          userId: user._id,
          email: user.email,
          role: user.userRole,
          type: user.userType,
        },
      };
    }

    // If user role/type is not handled
    throw new UnauthorizedException('Invalid user role or type');
  }

  async getInactiveUsers(): Promise<User[]> {
    return this.userModel.find({ status: 0 }).exec();
  }

  async approveUser(id: string): Promise<any> {

    const userdata = await this.userModel.find({_id:id}).exec();
    const savedUser=userdata[0];

    if (!savedUser) {
      return {
        status: 'failed',
        message: 'Invalid User',
      };
    }

    const plain = "Namaste! We are delighted to inform you that your bid limit has been approved by our team at Travancore Heritage Auction! A warm welcome to Kerala's first and most trusted auction house! We are thrilled to have you on board as a valued customer. Your trust in us is our greatest honor. We look forward to serving you with the finest numismatic, philatelic, and antique collectibles. Our team is committed to providing you with an unparalleled auction experience. Thank you for choosing Travancore Heritage Auction. We are excited to partner with you in your collecting journey! Best regards, Travancore Heritage Auction Team. Please don't hesitate to get in touch if you have any questions or enquiries. Contact Us: www.travancoreheritageauction.com, www.numisheritageindia@gmail.com. Phone Number 8848044033/ 7510624987.";
    const content = "<h3>Namaste</h3> <p>We are delighted to inform you that your bid limit has been approved by our team at Travancore Heritage Auction! <br><br>A warm welcome to Kerala's first and most trusted auction house! We are thrilled to have you on board as a valued customer. <br><br>We look forward to serving you with the finest numismatic, philatelic, and antique collectibles. Our team is committed to providing you with an unparalleled auction experience. <br><br>Thank you for choosing Travancore Heritage Auction. We are excited to partner with you in your collecting journey!<br><br>Best regards,<br>Travancore Heritage Auction Team<br><br>Please don't hesitate to get in touch if you have any questions or enquiries<br><br>Contact Us:<br><a href='https://www.travancoreheritageauction.com'>www.travancoreheritageauction.com</a><br><a href='mailto:numisheritageindia@gmail.com'>numisheritageindia@gmail.com</a><br><br>Phone Number 8848044033/ 7510624987</p>";
    console.log(this.sendEmail(savedUser.email,savedUser.firstname + ' ' + savedUser.lastname,plain,content,'Bid Limit Approval - Travancore Heritage Auction!'));


    return this.userModel.findByIdAndUpdate(
      id,
      { status: 1 }, // Update status to 1
      { new: true } // Return the updated document
    ).exec();
  }

  async approveOTP(id: string): Promise<User> {
    return this.userModel.findByIdAndUpdate(
      id,
      { otpstatus: 1 }, // Update status to 1
      { new: true } // Return the updated document
    ).exec();
  }

  async resendOTP(body): Promise<any> {
    const userdata = await this.userModel.find({email:body.email}).exec(); // Adjust based on your ORM or database query
    const user=userdata[0];
    console.log(user);
    if (!user) {
      return {
        status: 'failed',
        message: 'Invalid User',
      };
    }

    const digits = '0123456789';
    let newotp = '';
    for (let i = 0; i < 6; i++) {
      newotp += digits[Math.floor(Math.random() * digits.length)];
    }

    await this.userModel.findOneAndUpdate(
      {email:body.email},
      {
        $set: { otp: newotp }
      },
      { new: true, upsert: true } // `upsert: true` ensures the document is created if it doesn't exist
    );
    
    /*const response = await axios.post(
      'https://graph.facebook.com/v23.0/709680682221149/messages',
      {
        messaging_product: 'whatsapp',
        to: user.phone,
        type: 'template',
        template: {
          name: 'verification_otp',
          language: {
            code: 'en',
          },
          components: [
            {
              type: 'body',
              parameters: [
                {
                  type: 'text',
                  text: newotp, // Dynamic text value for the template placeholder
                },
              ],
            },
            {
              type: 'button',
              sub_type: 'url',
              index: 0,
              parameters: [
                {
                  type: 'text',
                  text: newotp, // Value to replace {{1}} in the button's URL template
                },
              ],
            },
          ],
        },
      },
      {
        headers: {
          'Content-Type': 'application/json',
          Authorization: 'Bearer EAAFVXw8ns9ABO7hGWIU57K1PZBOlvDtylqUt8AfVF5AXt5i8aTZAa2qeqcVpE9eorejrLggCrIgBau77usFS7CZAZAtXxyl2RK9Mh4Qhw4ZBPUq6s4ArkvM8VfPVnNm58ua6jXhOTzhfqCcrSzPzpjpSniq36tGKICBxqEjJfqSfK68Vqbb0stCuORwOd6kGEHGCPFHOIQlsiC9R2FDXdGHxpZBZBXTZCEcyrU4nw1wLugnjS5T2OtvIhjYZB00EiZAV6I2sjsEuvC5QZDZD',
        },
      },


    );*/
    

    const plain = "Dear " + user.firstname + ' ' + user.lastname + ", Use this OTP: " + newotp + " to reset your password.";
    const content = "<h3>Dear " + user.firstname + ' ' + user.lastname + ",</h3> <p>Use this OTP: " + newotp + " to reset your password.</p>";
    await this.sendEmail(user.email,user.firstname + ' ' + user.lastname,plain,content,'Change Password OTP - Travancore Heritage Auction!');

    return {
      status: 'success',
      message: 'OTP Sent succesfully',
    };
  }

  

  async resetPassword(body): Promise<any> {
    const user = await this.userModel.find({email:body.email}).exec();  // Adjust based on your ORM or database query
    if (!user) {
      return {
        status: 'failed',
        message: 'Invalid User',
      };
    }

    console.log(user);

    // Validate OTP
    if (body.otp!=user[0].otp) {
      return {
        status: 'failed',
        message: 'Invalid OTP. Please try again',
      };
    }

    const hashedPassword = await bcrypt.hash(body.newpassword, 10);

    await this.userModel.findByIdAndUpdate(user[0]._id, { password: hashedPassword }, { new: true }).exec();
    return {
        status: 'success',
        message: 'Password changed succesfully',
      };
  }

  async updateBidAmount(body): Promise<any> {
    this.userModel.findByIdAndUpdate(
      body.id,
      { status: 0 }, // Update status to 1
    ).exec();
    this.userModel.findByIdAndUpdate(
      body.id,
      { maxBidAmount: body.maxBidAmount }, 
    ).exec();
    const suser = await this.userModel.find({_id:body.id}).exec();
    const savedUser=suser[0];
    const adminplain = "Dear Admin, Bid Limit Request Notification. Customer Name: " + savedUser.firstname + ' ' + savedUser.lastname + ", Customer ID: THA"+savedUser.regno+". Mobile Number: "+savedUser.phone+". Request: Bid Limit Increase.";
    const admincontent = "<h3>Dear Admin, Bid Limit Request Notification.</h3><br><br><p> Customer Name: " + savedUser.firstname + ' ' + savedUser.lastname + ",<br>Customer ID: THA"+savedUser.regno+"<br>Mobile Number: "+savedUser.phone+"<br><br>Request: Bid Limit Increase.</p>";
    this.sendEmail('info@travancoreheritageauction.com',savedUser.firstname + ' ' + savedUser.lastname,adminplain,admincontent,'Bid Limit Request Notification');


    return {
      status: 'success',
      message: 'Update successful. Your Bidding amount will be approved by Admin',
    };
  }

  async changePassword(body): Promise<any> {
    const user = await this.userModel.findById(body.id); // Adjust based on your ORM or database query
    if (!user) {
      return {
        status: 'failed',
        message: 'Invalid User',
      };
    }

    // Validate current password
    const isPasswordValid = await bcrypt.compare(body.currentpassword, user.password);
    if (!isPasswordValid) {
      return {
        status: 'failed',
        message: 'Invalid Current Password. Please try again',
      };
    }

    const hashedPassword = await bcrypt.hash(body.newpassword, 10);

    await this.userModel.findByIdAndUpdate(body.id, { password: hashedPassword }, { new: true }).exec();
    return {
        status: 'success',
        message: 'Password changed succesfully',
      };
  }

  async sendEmail(to,name,plain,content,subject): Promise<any> {
      const mailjetAPIKey = 'a827249b18ef476acc5eb882fca8c1dd';
      const mailjetAPISecret = '8fb49d646c35592d0814f9ae7da771c4';

      const mailData = {
        Messages: [
          {
            From: {
              Email: "info@travancoreheritageauction.com",
              Name: "Travancore Heritage Auction"
            },
            To: [
              {
                Email: to,
                Name: name
              }
            ],
            Subject: subject,
            TextPart: plain,
            HTMLPart: content
          }
        ]
      };

      try {
        const response = await axios.post(
          'https://api.mailjet.com/v3.1/send',
          mailData,
          {
            headers: { 'Content-Type': 'application/json' },
            auth: {
              username: mailjetAPIKey,
              password: mailjetAPISecret
            }
          }
        );
        return 1;
      } catch (error) {
        return 2;
      }
  };

  async send(): Promise<any> {
    const plain = "Dear Sir, You have been successfully registered for the Travancore Cochin Heritage Auction. Thank you for choosing us! We’re excited to have you joined us for this extraordinary event.";
    const content = "<h3>Dear Sir,</h3> <br><p>You have been successfully registered for the Travancore Cochin Heritage Auction. <br><br>Thank you for choosing us! We’re excited to have you joined us for this extraordinary event.</p><p> Click <a href='https://travancoreheritageauction.com/auction/login'>here</a> to Login</p>";
    console.log(this.sendEmail('roopjithvn@gmail.com','Roopjith VN',plain,content,'Welcome to Travancore Heritage Auction!'));
  }

  async createData(body,user): Promise<any> {
    const currentTime = new Date();
    const newData = new this.previousdataModel({
      user: user,
      name: body.name,
      city: body.city,
      phone: body.phone,
      type: body.type,
      timestamps: currentTime,
    });

    await newData.save();
    return {
      statuscode:'success',
      message: 'Data Saved Sucessfully',
    };
  }

  async getData(user): Promise<any> {

    return await this.previousdataModel.find({ user: user }).exec();

  }

  async deleteData(body,user): Promise<any> {

    return await this.previousdataModel.findByIdAndDelete(body.id).exec();

  }

  async getUserData(body): Promise<any> {

    return await this.previousdataModel.find({ user: body.id }).exec();

  }

  async getTotalUsersCount(): Promise<any> {
    var count = await this.userModel.countDocuments().exec();
    return {
      statuscode:'success',
      count: count,
    };
  }
}
