import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Types } from 'mongoose';

@Schema()
export class Category extends Document {
  @Prop({ required: true, unique: true })
  name: string;

  @Prop()
  description: string;

  @Prop({ type: Types.ObjectId, ref: 'Category', required: false, default: null })
  category: Types.ObjectId;

  @Prop()
  image: string;
}

export const CategorySchema = SchemaFactory.createForClass(Category);
