import { IsNotEmpty, IsString, IsNumber, IsBoolean, IsOptional } from 'class-validator';
import { Transform } from 'class-transformer';
import { Types } from 'mongoose';

export class ProductDto {
  @IsOptional()
  @IsString()
  name?: string;

  @IsOptional()  
  @Transform(({ value }) => new Types.ObjectId(value.trim()), { toClassOnly: true })
  category: Types.ObjectId;

  @IsOptional()
  @IsString()
  description?: string;

  @IsOptional()
  @IsString()
  shortDescription?: string;

  @IsOptional()
  @IsString()
  auctionItemCondition?: string;

  @IsOptional()
  @IsString()
  auctionType?: string;

  @IsOptional()
  startPrice?: number;

  @IsOptional()
  bidIncrement?: number;

  @IsOptional()
  reservePrice?: number;

  @IsOptional()
  buyItNowPrice?: number;

  @IsOptional()
  auctionStartDate?: Date;

  @IsOptional()
  auctionEndDate?: Date;

  @IsOptional()
  extendAuctionOnBid?: boolean;

  @IsOptional()
  extendAuctionInLastSecond?: boolean;

  @IsOptional()
  extendAuctionForSeconds?: number;

  @IsOptional()
  tags?: string[];

  @IsOptional()
  images?: string[];

  @IsOptional()
  sku?: string;

  @IsOptional()
  lotNumber?: number;

  @IsOptional()
  hsncode?: string;

  @IsOptional()
  yearOfOrigin?: string;

  @IsOptional()
  material?: string;

  @IsOptional()
  mintMark?: string;

  @IsOptional()
  grade?: string;

  @IsOptional()
  rarity?: string;

  @IsOptional()
  weight?: string;

  @IsOptional()
  size?: string;

  @IsOptional()
  diameter?: string;

  @IsOptional()
  lotstart?: string;
}
