import {  Controller,  Get,  Post,  Query,  Body,  Param,  Put,  Delete,  UploadedFiles,  UseInterceptors,  UseGuards,  BadRequestException, UsePipes, ValidationPipe} from '@nestjs/common';
import { SettingsService } from './settings.service';
import { SettingsDto } from './settings.dto';
import { JwtAuthGuard } from '../auth/jwt-auth.guard';
import { Setting, SettingSchema } from './setting.schema';

@Controller('settings') // Base route for all user endpoints
export class SettingsController {
  constructor(private readonly settingsService: SettingsService) {}

  @UseGuards(JwtAuthGuard)
  @Post()
  @UsePipes(new ValidationPipe({ transform: true }))
  async createBidIncrement(@Body() body: any, settingsDto: SettingsDto,) {
    //const transformed = new settingsDto();
    //Object.assign(transformed, body);
    console.log(body);
    return this.settingsService.createIncrement(body);
  }

  @UseGuards(JwtAuthGuard)
  @Get()
  async getIncrements(): Promise<Setting[]> {
    return this.settingsService.findAll();
  }

  @UseGuards(JwtAuthGuard)
  @Delete(':id')
  async delete(@Param('id') id: string): Promise<any> {
    return this.settingsService.delete(id);
  }
}
