import { Controller, Get,Req, Post, Put, Delete, Param, Body, UseGuards  } from '@nestjs/common';
import { UsersService } from './users.service';
import { CreateUserDto } from './dto/create-user.dto';
import { LoginUserDto } from './dto/login-user.dto';
import { JwtAuthGuard } from '../auth/jwt-auth.guard';

@Controller('users') // Base route for all user endpoints
export class UsersController {
  constructor(private readonly usersService: UsersService) {}

  @UseGuards(JwtAuthGuard)
  @Post()
  async createUser(@Body() createUserDto: any) {
    return this.usersService.createUser(createUserDto);
  }

  @UseGuards(JwtAuthGuard)
  @Get('dashboard')
  getDashboard(@Req() req) {
    const user = req.user; // user object extracted from token
    return {
      status: 'success',
      message: 'Welcome to the dashboard',
      user,
    };
  }

  @Post('register')
  async registerUser(@Body() createUserDto: CreateUserDto) {
    console.log(createUserDto);
   const userstatus = await this.usersService.createUser(createUserDto);
   return {
      status: 'success',
      message: 'Your account has been created and login details has been shared to your email. Please Login to start bidding.',
    };
  }

  @UseGuards(JwtAuthGuard)
  @Get()
  async getAllUsers() {
    return this.usersService.getAllUsers();
  }

  @UseGuards(JwtAuthGuard)
  @Post('inactive')
  async getInactiveUsers() {
    return await this.usersService.getInactiveUsers();
  }

  @UseGuards(JwtAuthGuard)
  @Post('approve/:id')
  async updateInactiveUsers(@Param('id') id: string) {
    const updatedUser = await this.usersService.approveUser(id);
    if (!updatedUser) {
      return { message: 'User not found or already approved' };
    }
    return { message: 'User approved successfully', user: updatedUser };
  }

  // Get a user by ID
  @Get(':id')
  async getUserById(@Param('id') id: string) {
    return this.usersService.getUserById(id);
  }

  // Update a user by ID
  @Put(':id')
  async updateUser(@Param('id') id: string, @Body() updateUserDto: any) {
    return this.usersService.updateUser(id, updateUserDto);
  }

  // Delete a user by ID
  @Delete(':id')
  async deleteUser(@Param('id') id: string) {
    return this.usersService.deleteUser(id);
  }

  @Post('login')
  async login(@Body() loginUserDto: LoginUserDto) {
    return await this.usersService.login(loginUserDto);
  }

  @UseGuards(JwtAuthGuard)
  @Post('profile')
  async getProfile(@Req() req) {
    //const user = req.user; // user object extracted from token
    const user = await this.usersService.getUserById(req.user.userId);
    return {
      status: 'success',
      message: 'User Data',
      userdata: user,
    };
  }
}
